/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyEngine;

public class PolicyVerificationInInterceptor
extends AbstractPolicyInterceptor {
    public static final PolicyVerificationInInterceptor INSTANCE = new PolicyVerificationInInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyVerificationInInterceptor.class);

    public PolicyVerificationInInterceptor() {
        super("pre-invoke");
    }

    protected void handle(Message message) {
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        if (null == aim) {
            return;
        }
        Exchange exchange = message.getExchange();
        BindingOperationInfo boi = exchange.get(BindingOperationInfo.class);
        if (null == boi) {
            LOG.fine("No binding operation info.");
            return;
        }
        Endpoint e = exchange.get(Endpoint.class);
        if (null == e) {
            LOG.fine("No endpoint.");
            return;
        }
        EndpointInfo ei = e.getEndpointInfo();
        Bus bus = exchange.get(Bus.class);
        PolicyEngine pe = bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        if (MessageUtils.isPartialResponse(message)) {
            LOG.fine("Not verifying policies on inbound partial response.");
            return;
        }
        this.getTransportAssertions(message);
        EffectivePolicy effectivePolicy = message.get(EffectivePolicy.class);
        if (effectivePolicy == null) {
            effectivePolicy = MessageUtils.isRequestor(message) ? pe.getEffectiveClientResponsePolicy(ei, boi) : pe.getEffectiveServerRequestPolicy(ei, boi);
        }
        aim.checkEffectivePolicy(effectivePolicy.getPolicy());
        LOG.fine("Verified policies for inbound message.");
    }
}

