/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class ProxyClassLoader
extends ClassLoader {
    private final Class<?>[] classes;
    private final Set<ClassLoader> loaders = new HashSet<ClassLoader>();
    private boolean checkSystem;

    public ProxyClassLoader() {
        this.classes = null;
    }

    public ProxyClassLoader(Class<?>[] cls) {
        this.classes = cls;
    }

    public void addLoader(ClassLoader loader) {
        if (loader == null) {
            this.checkSystem = true;
        } else {
            this.loaders.add(loader);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.classes != null) {
            for (Class<?> c : this.classes) {
                if (!name.equals(c.getName())) continue;
                return c;
            }
        }
        for (ClassLoader loader : this.loaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (NoClassDefFoundError cnfe) {
            }
        }
        if (this.checkSystem) {
            try {
                return ProxyClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL findResource(String name) {
        for (ClassLoader loader : this.loaders) {
            URL url = loader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }
}

