/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.specific.SpecificData;

public class SpecificDatumReader<T>
extends GenericDatumReader<T> {
    private static final Class<?>[] NO_ARG = new Class[0];
    private static final Class<?>[] SCHEMA_ARG = new Class[]{Schema.class};
    private static final Map<Class, Constructor> CTOR_CACHE = new ConcurrentHashMap<Class, Constructor>();

    public SpecificDatumReader() {
    }

    public SpecificDatumReader(Class<T> c) {
        this(SpecificData.get().getSchema(c));
    }

    public SpecificDatumReader(Schema schema) {
        super(schema);
    }

    public SpecificDatumReader(Schema writer, Schema reader) {
        super(writer, reader);
    }

    @Override
    protected Object newRecord(Object old, Schema schema) {
        Class c = SpecificData.get().getClass(schema);
        if (c == null) {
            return super.newRecord(old, schema);
        }
        return c.isInstance(old) ? old : SpecificDatumReader.newInstance(c, schema);
    }

    @Override
    protected Object createEnum(String symbol, Schema schema) {
        Class c = SpecificData.get().getClass(schema);
        if (c == null) {
            return super.createEnum(symbol, schema);
        }
        return Enum.valueOf(c, symbol);
    }

    @Override
    protected Object createFixed(Object old, Schema schema) {
        Class c = SpecificData.get().getClass(schema);
        if (c == null) {
            return super.createFixed(old, schema);
        }
        return c.isInstance(old) ? old : SpecificDatumReader.newInstance(c, schema);
    }

    protected static Object newInstance(Class c, Schema s) {
        Object result;
        boolean useSchema = SchemaConstructable.class.isAssignableFrom(c);
        try {
            Object[] objectArray;
            Constructor meth = CTOR_CACHE.get(c);
            if (meth == null) {
                meth = c.getDeclaredConstructor(useSchema ? SCHEMA_ARG : NO_ARG);
                meth.setAccessible(true);
                CTOR_CACHE.put(c, meth);
            }
            if (useSchema) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = s;
            } else {
                objectArray = null;
            }
            result = meth.newInstance(objectArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static interface SchemaConstructable {
    }
}

