/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.web.util.ExpressionRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AggregateDefinitionRenderer {
    private AggregateDefinitionRenderer() {
    }

    public static void render(StringBuilder buffer, ProcessorDefinition<?> processor) {
        AggregateDefinition aggregate = (AggregateDefinition)processor;
        buffer.append(".").append(aggregate.getShortName()).append("()");
        ExpressionRenderer.render(buffer, aggregate.getExpression());
        if (aggregate.getBatchTimeout() != null) {
            buffer.append(".batchTimeout(").append(aggregate.getBatchTimeout());
            buffer.append(aggregate.getBatchTimeout() < 1000L ? "L)" : ")");
        }
        if (aggregate.getBatchSize() != null) {
            buffer.append(".batchSize(").append(aggregate.getBatchSize()).append(")");
        }
        if (aggregate.getGroupExchanges() != null && aggregate.getGroupExchanges().booleanValue()) {
            buffer.append(".groupExchanges()");
        }
    }
}

