/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.web.resources.CamelChildResourceSupport;
import org.apache.camel.web.resources.CamelContextResource;
import org.apache.camel.web.resources.ConvertersResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertersFromResource
extends CamelChildResourceSupport {
    private Class type;

    public ConvertersFromResource(CamelContextResource contextResource, Class type) {
        super(contextResource);
        this.type = type;
    }

    public Map<String, TypeConverter> getConverters() {
        TreeMap<String, TypeConverter> answer = new TreeMap<String, TypeConverter>();
        DefaultTypeConverter converter = this.getDefaultTypeConverter();
        if (converter != null) {
            Map classes = converter.getToClassMappings(this.type);
            for (Map.Entry entry : classes.entrySet()) {
                Class aClass = (Class)entry.getKey();
                String name = ConvertersResource.nameOf(aClass);
                answer.put(name, (TypeConverter)entry.getValue());
            }
        }
        return answer;
    }

    public Class getType() {
        return this.type;
    }
}

