/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.web.model.EndpointLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Endpoints {
    @XmlElement(name="endpoint")
    private List<EndpointLink> endpoints = new ArrayList<EndpointLink>();

    public Endpoints() {
    }

    public Endpoints(CamelContext camelContext) {
        this();
        this.load(camelContext);
    }

    public String toString() {
        return "Endpoints" + this.endpoints;
    }

    public List<EndpointLink> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<EndpointLink> endpoints) {
        this.endpoints = endpoints;
    }

    public void load(CamelContext camelContext) {
        ObjectHelper.notNull((Object)camelContext, (String)"camelContext has not been injected!");
        Map map = camelContext.getEndpointMap();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            this.addEndpoint(this.createEndpointLink((String)entry.getKey(), (Endpoint)entry.getValue()));
        }
    }

    protected EndpointLink createEndpointLink(String key, Endpoint endpoint) {
        EndpointLink answer = new EndpointLink();
        answer.load(key, endpoint);
        return answer;
    }

    public void addEndpoint(EndpointLink endpointLink) {
        this.getEndpoints().add(endpointLink);
    }
}

