/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;
import org.apache.woden.internal.util.dom.DOM2Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolicyUtil {
    public static String getSafeString(String unsafeString) {
        StringBuffer sbuf = new StringBuffer();
        char[] chars = unsafeString.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    sbuf.append('\\');
                    sbuf.append('\\');
                    continue block6;
                }
                case '\"': {
                    sbuf.append('\\');
                    sbuf.append('\"');
                    continue block6;
                }
                case '\n': {
                    sbuf.append('\\');
                    sbuf.append('n');
                    continue block6;
                }
                case '\r': {
                    sbuf.append('\\');
                    sbuf.append('r');
                    continue block6;
                }
                default: {
                    sbuf.append(c);
                }
            }
        }
        return sbuf.toString();
    }

    public static OMElement getPolicyComponentAsOMElement(PolicyComponent policyComponent, ExternalPolicySerializer externalPolicySerializer) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (policyComponent instanceof Policy) {
            externalPolicySerializer.serialize((Policy)policyComponent, baos);
        } else {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
            policyComponent.serialize(writer);
            writer.flush();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)XMLInputFactory.newInstance().createXMLStreamReader(bais)).getDocumentElement();
    }

    public static OMElement getPolicyComponentAsOMElement(PolicyComponent component) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
        component.serialize(writer);
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)XMLInputFactory.newInstance().createXMLStreamReader(bais)).getDocumentElement();
    }

    public static PolicyComponent getPolicyComponentFromOMElement(OMElement policyComponent) throws IllegalArgumentException {
        if (policyComponent instanceof Policy) {
            return PolicyEngine.getPolicy((OMElement)policyComponent);
        }
        if (policyComponent instanceof PolicyReference) {
            return PolicyEngine.getPolicyReference((OMElement)policyComponent);
        }
        throw new IllegalArgumentException("Agrument is neither a <wsp:Policy> nor a <wsp:PolicyReference> element");
    }

    public static PolicyComponent getPolicyComponent(Element element) {
        if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(element.getNamespaceURI())) {
            if ("Policy".equals(element.getLocalName())) {
                String xmlString = DOM2Writer.nodeToString((Node)element);
                ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                return PolicyEngine.getPolicy((InputStream)bais);
            }
            if ("PolicyReference".equals(element.getLocalName())) {
                String xmlString = DOM2Writer.nodeToString((Node)element);
                ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                return PolicyEngine.getPolicyReferene((InputStream)bais);
            }
        }
        throw new IllegalArgumentException("Agrument is neither a <wsp:Policy> nor a <wsp:PolicyReference> element");
    }

    public static String policyComponentToString(PolicyComponent policyComponent) throws XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
        policyComponent.serialize(writer);
        writer.flush();
        return baos.toString();
    }
}

