/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSMessageReceiver;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.axis2.util.threadpool.DefaultThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSListener
implements TransportListener {
    private static final Log log = LogFactory.getLog((Class)JMSListener.class);
    private static final int WORKERS_MAX_THREADS = 100;
    private static final long WORKER_KEEP_ALIVE = 60L;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private Map connectionFactories = new HashMap();
    private Map serviceNameToEprMap = new HashMap();
    private ConfigurationContext axisConf = null;

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) {
        this.axisConf = axisConf;
        this.initializeConnectionFactories(transprtIn);
        if (this.connectionFactories.isEmpty()) {
            log.warn((Object)"No JMS connection factories are defined.Will not listen for any JMS messages");
            return;
        }
        Iterator services = axisConf.getAxisConfiguration().getServices().values().iterator();
        while (services.hasNext()) {
            AxisService service = (AxisService)services.next();
            if (!JMSUtils.isJMSService(service)) continue;
            this.processService(service);
        }
        axisConf.getAxisConfiguration().addObservers(new JMSAxisObserver());
        log.info((Object)"JMS Transport Receiver (Listener) initialized...");
    }

    private void processService(AxisService service) {
        JMSConnectionFactory cf = this.getConnectionFactory(service);
        if (cf == null) {
            String msg = "Service " + service.getName() + " does not specify" + "a JMS connection factory or refers to an invalid factory. " + "This service is being marked as faulty and will not be " + "available over the JMS transport";
            log.warn((Object)msg);
            JMSUtils.markServiceAsFaulty(service.getName(), msg, service.getAxisConfiguration());
            return;
        }
        String destination = JMSUtils.getDestination(service);
        this.serviceNameToEprMap.put(service.getName(), JMSListener.getEPR(cf, destination));
        cf.addDestination(destination, service.getName());
    }

    private JMSConnectionFactory getConnectionFactory(AxisService service) {
        Parameter conFacParam = service.getParameter("transport.jms.ConnectionFactory");
        if (conFacParam != null) {
            String conFac = (String)conFacParam.getValue();
            if (this.connectionFactories.containsKey(conFac)) {
                return (JMSConnectionFactory)this.connectionFactories.get(conFac);
            }
            return null;
        }
        if (this.connectionFactories.containsKey("default")) {
            return (JMSConnectionFactory)this.connectionFactories.get("default");
        }
        return null;
    }

    private void initializeConnectionFactories(TransportInDescription transprtIn) {
        Iterator conFacIter = transprtIn.getParameters().iterator();
        while (conFacIter.hasNext()) {
            Parameter param = (Parameter)conFacIter.next();
            JMSConnectionFactory jmsConFactory = new JMSConnectionFactory(param.getName());
            ParameterIncludeImpl pi = new ParameterIncludeImpl();
            try {
                pi.deserializeParameters((OMElement)param.getValue());
            }
            catch (AxisFault axisFault) {
                this.handleException("Error reading Parameters for JMS connection factory" + jmsConFactory.getName(), axisFault);
            }
            Iterator params = pi.getParameters().iterator();
            while (params.hasNext()) {
                Parameter p = (Parameter)params.next();
                if ("java.naming.factory.initial".equals(p.getName())) {
                    jmsConFactory.addProperty("java.naming.factory.initial", (String)p.getValue());
                    continue;
                }
                if ("java.naming.provider.url".equals(p.getName())) {
                    jmsConFactory.addProperty("java.naming.provider.url", (String)p.getValue());
                    continue;
                }
                if ("java.naming.security.principal".equals(p.getName())) {
                    jmsConFactory.addProperty("java.naming.security.principal", (String)p.getValue());
                    continue;
                }
                if ("java.naming.security.credentials".equals(p.getName())) {
                    jmsConFactory.addProperty("java.naming.security.credentials", (String)p.getValue());
                    continue;
                }
                if ("transport.jms.ConnectionFactoryJNDIName".equals(p.getName())) {
                    jmsConFactory.setJndiName((String)p.getValue());
                    continue;
                }
                if (!"transport.jms.Destination".equals(p.getName())) continue;
                StringTokenizer st = new StringTokenizer((String)p.getValue(), " ,");
                while (st.hasMoreTokens()) {
                    jmsConFactory.addDestination(st.nextToken(), null);
                }
            }
            try {
                jmsConFactory.connect();
                this.connectionFactories.put(jmsConFactory.getName(), jmsConFactory);
            }
            catch (NamingException e) {
                this.handleException("Error connecting to JMS connection factory : " + jmsConFactory.getJndiName(), e);
            }
        }
    }

    private static String getEPR(JMSConnectionFactory cf, String destination) {
        StringBuffer sb = new StringBuffer();
        sb.append("jms:/").append(destination);
        sb.append("?").append("transport.jms.ConnectionFactoryJNDIName").append("=").append(cf.getJndiName());
        Iterator props = cf.getProperties().keySet().iterator();
        while (props.hasNext()) {
            String key = (String)props.next();
            String value = (String)cf.getProperties().get(key);
            sb.append("&").append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public void start() throws AxisFault {
        ThreadPoolExecutor workerPool = new ThreadPoolExecutor(1, 100, 60L, TIME_UNIT, (BlockingQueue)new LinkedBlockingQueue(), (ThreadFactory)new DefaultThreadFactory(new ThreadGroup("JMS Worker thread group"), "JMSWorker"));
        Iterator iter = this.connectionFactories.values().iterator();
        while (iter.hasNext()) {
            JMSConnectionFactory conFac = (JMSConnectionFactory)iter.next();
            JMSMessageReceiver msgRcvr = new JMSMessageReceiver(conFac, (Executor)workerPool, this.axisConf);
            try {
                conFac.listen(msgRcvr);
            }
            catch (JMSException e) {
                this.handleException("Error starting connection factory : " + conFac.getName(), (Exception)((Object)e));
            }
        }
    }

    public void stop() {
        Iterator iter = this.connectionFactories.values().iterator();
        while (iter.hasNext()) {
            ((JMSConnectionFactory)iter.next()).stop();
        }
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        if (serviceName.indexOf(47) != -1) {
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        return new EndpointReference[]{new EndpointReference((String)this.serviceNameToEprMap.get(serviceName))};
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    private void startListeningForService(AxisService service) {
        this.processService(service);
        JMSConnectionFactory cf = this.getConnectionFactory(service);
        if (cf == null) {
            String msg = "Service " + service.getName() + " does not specify" + "a JMS connection factory or refers to an invalid factory." + "This service is being marked as faulty and will not be " + "available over the JMS transport";
            log.warn((Object)msg);
            JMSUtils.markServiceAsFaulty(service.getName(), msg, service.getAxisConfiguration());
            return;
        }
        String destination = JMSUtils.getDestination(service);
        try {
            cf.listenOnDestination(destination);
            log.info((Object)("Started listening on destination : " + destination + " for service " + service.getName()));
        }
        catch (JMSException e) {
            this.handleException("Could not listen on JMS for service " + service.getName(), (Exception)((Object)e));
            JMSUtils.markServiceAsFaulty(service.getName(), e.getMessage(), service.getAxisConfiguration());
        }
    }

    private void stopListeningForService(AxisService service) {
        JMSConnectionFactory cf = this.getConnectionFactory(service);
        if (cf == null) {
            String msg = "Service " + service.getName() + " does not specify" + "a JMS connection factory or refers to an invalid factory." + "This service is being marked as faulty and will not be " + "available over the JMS transport";
            log.warn((Object)msg);
            JMSUtils.markServiceAsFaulty(service.getName(), msg, service.getAxisConfiguration());
            return;
        }
        this.serviceNameToEprMap.remove(service.getName());
        String destination = JMSUtils.getDestination(service);
        try {
            cf.removeDestination(destination);
        }
        catch (JMSException e) {
            this.handleException("Error while terminating listening on JMS destination : " + destination, (Exception)((Object)e));
        }
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new AxisJMSException(msg, e);
    }

    public ConfigurationContext getConfigurationContext() {
        return this.axisConf;
    }

    class JMSAxisObserver
    implements AxisObserver {
        JMSAxisObserver() {
        }

        public void init(AxisConfiguration axisConfig) {
        }

        public void serviceUpdate(AxisEvent event, AxisService service) {
            if (JMSUtils.isJMSService(service)) {
                switch (event.getEventType()) {
                    case 1: {
                        JMSListener.this.startListeningForService(service);
                        break;
                    }
                    case 0: {
                        JMSListener.this.stopListeningForService(service);
                        break;
                    }
                    case 3: {
                        JMSListener.this.startListeningForService(service);
                        break;
                    }
                    case 2: {
                        JMSListener.this.stopListeningForService(service);
                    }
                }
            }
        }

        public void moduleUpdate(AxisEvent event, AxisModule module) {
        }

        public void addParameter(Parameter param) throws AxisFault {
        }

        public void removeParameter(Parameter param) throws AxisFault {
        }

        public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        }

        public Parameter getParameter(String name) {
            return null;
        }

        public ArrayList getParameters() {
            return null;
        }

        public boolean isParameterLocked(String parameterName) {
            return false;
        }

        public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
        }
    }
}

