/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class RequestSessionCookie
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String sessionCookie = null;
        Header[] headers = request.getHeaders("Cookie");
        for (int i = 0; i < headers.length; ++i) {
            HeaderElement[] elements = headers[i].getElements();
            for (int e = 0; e < elements.length; ++e) {
                HeaderElement element = elements[e];
                if (!"axis_session".equalsIgnoreCase(element.getName())) continue;
                sessionCookie = element.getValue();
            }
        }
        context.setAttribute("Cookie", sessionCookie);
    }
}

