/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MIMEOutputUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.http.AbstractHTTPSender;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class SOAPOverHTTPSender
extends AbstractHTTPSender {
    public void send(MessageContext msgContext, OMElement dataout, URL url, String soapActionString) throws MalformedURLException, AxisFault, IOException {
        long timeout;
        Object cookieString;
        String charEncoding;
        HttpClient httpClient = this.getHttpClient(msgContext);
        PostMethod postMethod = new PostMethod(url.toString());
        if (this.isAuthenticationEnabled(msgContext)) {
            postMethod.setDoAuthentication(true);
        }
        if ((charEncoding = (String)msgContext.getProperty("CHARACTER_SET_ENCODING")) == null) {
            charEncoding = "UTF-8";
        }
        postMethod.setPath(url.getPath());
        postMethod.setRequestEntity((RequestEntity)new AxisSOAPRequestEntity(dataout, this.chunked, msgContext, charEncoding, soapActionString));
        if (!this.httpVersion.equals("HTTP/1.0") && this.chunked) {
            postMethod.setContentChunked(true);
        }
        if (msgContext.isSOAP11()) {
            if ("".equals(soapActionString)) {
                postMethod.setRequestHeader("SOAPAction", "\"\"");
            } else {
                if (soapActionString != null && !soapActionString.startsWith("\"")) {
                    soapActionString = "\"" + soapActionString + "\"";
                }
                postMethod.setRequestHeader("SOAPAction", soapActionString);
            }
        }
        if ((cookieString = msgContext.getProperty("Cookie")) != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("axis_session");
            buffer.append("=");
            buffer.append(cookieString);
            postMethod.setRequestHeader("Cookie", buffer.toString());
        }
        postMethod.setRequestHeader("Host", url.getHost());
        if (this.httpVersion != null) {
            if (this.httpVersion.equals("HTTP/1.0")) {
                httpClient.getParams().setVersion(HttpVersion.HTTP_1_0);
            } else {
                postMethod.setRequestHeader("Expect", "100-continue");
            }
        }
        if ((timeout = msgContext.getOptions().getTimeOutInMilliSeconds()) != 0L) {
            httpClient.getParams().setSoTimeout((int)timeout);
        }
        this.executeMethod(httpClient, msgContext, url, (HttpMethod)postMethod);
        if (postMethod.getStatusCode() == 200) {
            this.processResponse((HttpMethodBase)postMethod, msgContext);
            return;
        }
        if (postMethod.getStatusCode() == 202) {
            return;
        }
        if (postMethod.getStatusCode() == 500) {
            String value;
            Header contentTypeHeader = postMethod.getResponseHeader("Content-Type");
            if (contentTypeHeader != null && ((value = contentTypeHeader.getValue()).indexOf("text/xml") >= 0 || value.indexOf("application/soap+xml") >= 0)) {
                this.processResponse((HttpMethodBase)postMethod, msgContext);
                return;
            }
        } else {
            throw new AxisFault(Messages.getMessage("httpTransportError", String.valueOf(postMethod.getStatusCode()), postMethod.getStatusText()), "Sender");
        }
        throw new AxisFault(Messages.getMessage("transportError", String.valueOf(postMethod.getStatusCode()), postMethod.getResponseBodyAsString()));
    }

    public class AxisSOAPRequestEntity
    implements RequestEntity {
        private boolean doingMTOM = false;
        private boolean doingSWA = false;
        private byte[] bytes;
        private String charSetEnc;
        private boolean chunked;
        private OMElement element;
        private MessageContext msgCtxt;
        private String soapActionString;

        public AxisSOAPRequestEntity(OMElement element, boolean chunked, MessageContext msgCtxt, String charSetEncoding, String soapActionString) {
            this.element = element;
            this.chunked = chunked;
            this.msgCtxt = msgCtxt;
            this.doingMTOM = msgCtxt.isDoingMTOM();
            this.doingSWA = msgCtxt.isDoingSwA();
            this.charSetEnc = charSetEncoding;
            this.soapActionString = soapActionString;
        }

        private void handleOMOutput(OutputStream out, boolean doingMTOM) throws XMLStreamException {
            SOAPOverHTTPSender.this.format.setDoOptimize(doingMTOM);
            SOAPOverHTTPSender.this.format.setDoingSWA(this.doingSWA);
            if (!doingMTOM & this.doingSWA) {
                StringWriter bufferedSOAPBody = new StringWriter();
                if (SOAPOverHTTPSender.this.isAllowedRetry) {
                    this.element.serialize((Writer)bufferedSOAPBody, SOAPOverHTTPSender.this.format);
                } else {
                    this.element.serializeAndConsume((Writer)bufferedSOAPBody, SOAPOverHTTPSender.this.format);
                }
                MIMEOutputUtils.writeSOAPWithAttachmentsMessage((StringWriter)bufferedSOAPBody, (OutputStream)out, (Attachments)this.msgCtxt.getAttachmentMap(), (OMOutputFormat)SOAPOverHTTPSender.this.format);
            } else if (SOAPOverHTTPSender.this.isAllowedRetry) {
                this.element.serialize(out, SOAPOverHTTPSender.this.format);
            } else {
                this.element.serializeAndConsume(out, SOAPOverHTTPSender.this.format);
            }
        }

        public byte[] writeBytes() throws AxisFault {
            try {
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                if (!this.doingMTOM) {
                    OMOutputFormat format2 = new OMOutputFormat();
                    format2.setCharSetEncoding(this.charSetEnc);
                    if (this.doingSWA) {
                        StringWriter bufferedSOAPBody = new StringWriter();
                        this.element.serializeAndConsume((Writer)bufferedSOAPBody, format2);
                        MIMEOutputUtils.writeSOAPWithAttachmentsMessage((StringWriter)bufferedSOAPBody, (OutputStream)bytesOut, (Attachments)this.msgCtxt.getAttachmentMap(), (OMOutputFormat)format2);
                    } else {
                        this.element.serializeAndConsume((OutputStream)bytesOut, format2);
                    }
                    return bytesOut.toByteArray();
                }
                SOAPOverHTTPSender.this.format.setCharSetEncoding(this.charSetEnc);
                SOAPOverHTTPSender.this.format.setDoOptimize(true);
                this.element.serializeAndConsume((OutputStream)bytesOut, SOAPOverHTTPSender.this.format);
                return bytesOut.toByteArray();
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
            catch (FactoryConfigurationError e) {
                throw new AxisFault(e);
            }
        }

        public void writeRequest(OutputStream out) throws IOException {
            Object gzip = this.msgCtxt.getOptions().getProperty("transport.http.gzipRequest");
            if (gzip != null && JavaUtils.isTrueExplicitly(gzip) && this.chunked) {
                out = new GZIPOutputStream(out);
            }
            try {
                if (this.chunked) {
                    this.handleOMOutput(out, this.doingMTOM);
                } else {
                    if (this.bytes == null) {
                        this.bytes = this.writeBytes();
                    }
                    out.write(this.bytes);
                }
                if (out instanceof GZIPOutputStream) {
                    ((GZIPOutputStream)out).finish();
                }
                out.flush();
            }
            catch (XMLStreamException e) {
                throw new AxisFault(e);
            }
            catch (FactoryConfigurationError e) {
                throw new AxisFault(e);
            }
            catch (IOException e) {
                throw new AxisFault(e);
            }
        }

        public long getContentLength() {
            try {
                if (this.chunked) {
                    return -1L;
                }
                if (this.bytes == null) {
                    this.bytes = this.writeBytes();
                }
                return this.bytes.length;
            }
            catch (AxisFault e) {
                return -1L;
            }
        }

        public String getContentType() {
            String encoding = SOAPOverHTTPSender.this.format.getCharSetEncoding();
            String contentType = SOAPOverHTTPSender.this.format.getContentType();
            if (encoding != null) {
                contentType = contentType + "; charset=" + encoding;
            }
            if (!(this.msgCtxt.isSOAP11() || this.soapActionString == null || "".equals(this.soapActionString.trim()) || "\"\"".equals(this.soapActionString.trim()))) {
                contentType = contentType + ";action=\"" + this.soapActionString + "\";";
            }
            return contentType;
        }

        public boolean isRepeatable() {
            return true;
        }
    }
}

