/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPActionBasedDispatcher
extends AbstractDispatcher {
    public static final String NAME = "SOAPActionBasedDispatcher";
    private static final Log log = LogFactory.getLog((Class)SOAPActionBasedDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        String action = messageContext.getSoapAction();
        log.debug((Object)("Checking for Operation using SOAPAction : " + action));
        if (action != null) {
            AxisOperation op = service.getOperationBySOAPAction(action);
            if (op == null) {
                op = service.getOperationByAction(action);
            }
            if (op == null && action.lastIndexOf(47) != -1) {
                op = service.getOperation(new QName(action.substring(action.lastIndexOf(47), action.length())));
            }
            return op;
        }
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        log.debug((Object)"Checking for Service using SOAPAction is a TODO item");
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

