/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.DescriptionConstants;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;

public abstract class AxisDescription
implements ParameterInclude,
DescriptionConstants {
    private AxisDescription parent = null;
    private ParameterInclude parameterInclude;
    private PolicyInclude policyInclude = null;
    private HashMap children;
    private Log log = LogFactory.getLog(this.getClass());

    public AxisDescription() {
        this.parameterInclude = new ParameterIncludeImpl();
        this.children = new HashMap();
    }

    public void addParameter(Parameter param) throws AxisFault {
        if (param == null) {
            return;
        }
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameterInclude.addParameter(param);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameterInclude.removeParameter(param);
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameterInclude.deserializeParameters(parameterElement);
    }

    public Parameter getParameter(String name) {
        Parameter parameter = this.parameterInclude.getParameter(name);
        if (parameter == null && this.parent != null) {
            return this.parent.getParameter(name);
        }
        return parameter;
    }

    public Object getParameterValue(String name) {
        Parameter param = this.getParameter(name);
        if (param == null) {
            return null;
        }
        return param.getValue();
    }

    public ArrayList getParameters() {
        return this.parameterInclude.getParameters();
    }

    public boolean isParameterLocked(String parameterName) {
        if (this.parent != null && this.parent.isParameterLocked(parameterName)) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setParent(AxisDescription parent) {
        this.parent = parent;
    }

    public AxisDescription getParent() {
        return this.parent;
    }

    public void setPolicyInclude(PolicyInclude policyInclude) {
        this.policyInclude = policyInclude;
    }

    public PolicyInclude getPolicyInclude() {
        if (this.policyInclude == null) {
            this.policyInclude = new PolicyInclude(this);
        }
        return this.policyInclude;
    }

    public void addChild(AxisDescription child) {
        this.children.put(child.getKey(), child);
    }

    public void addChild(Object key, AxisDescription child) {
        this.children.put(key, child);
    }

    public Iterator getChildren() {
        return this.children.values().iterator();
    }

    public AxisDescription getChild(Object key) {
        return (AxisDescription)this.children.get(key);
    }

    public void removeChild(Object key) {
        this.children.remove(key);
    }

    public void applyPolicy(Policy policy) throws AxisFault {
        AxisConfiguration configuration = this.getAxisConfiguration();
        if (configuration == null) {
            return;
        }
        this.getPolicyInclude().setPolicy(policy);
        Policy effPolicy = this.getPolicyInclude().getEffectivePolicy();
        Iterator iterator = effPolicy.getAlternatives();
        if (!iterator.hasNext()) {
            throw new AxisFault("Policy doesn't contain any policy alternatives");
        }
        List assertionList = (List)iterator.next();
        ArrayList<String> namespaceList = new ArrayList<String>();
        ArrayList modulesToEngage = new ArrayList();
        Iterator assertions = assertionList.iterator();
        while (assertions.hasNext()) {
            Assertion assertion = (Assertion)assertions.next();
            String namespaceURI = assertion.getName().getNamespaceURI();
            List moduleList = configuration.getModulesForPolicyNamesapce(namespaceURI);
            if (moduleList == null) {
                this.log.debug((Object)("can't find any module to process " + assertion.getName() + " type assertions"));
                continue;
            }
            if (!this.canSupportAssertion(assertion, moduleList)) {
                throw new AxisFault("atleast one module can't support " + assertion.getName());
            }
            if (namespaceList.contains(namespaceURI)) continue;
            namespaceList.add(namespaceURI);
            modulesToEngage.addAll(moduleList);
        }
        this.engageModulesToAxisDescription(modulesToEngage, this);
    }

    public void applyPolicy() throws AxisFault {
        if (this instanceof AxisMessage) {
            return;
        }
        AxisConfiguration configuration = this.getAxisConfiguration();
        if (configuration == null) {
            return;
        }
        Policy effPolicy = this.getPolicyInclude().getEffectivePolicy();
        if (effPolicy != null) {
            Iterator iterator = effPolicy.getAlternatives();
            if (!iterator.hasNext()) {
                throw new AxisFault("Policy doesn't contain any policy alternatives");
            }
            List assertionList = (List)iterator.next();
            ArrayList<String> namespaceList = new ArrayList<String>();
            ArrayList modulesToEngage = new ArrayList();
            Iterator assertions = assertionList.iterator();
            while (assertions.hasNext()) {
                Assertion assertion = (Assertion)assertions.next();
                String namespaceURI = assertion.getName().getNamespaceURI();
                List moduleList = configuration.getModulesForPolicyNamesapce(namespaceURI);
                if (moduleList == null) {
                    this.log.debug((Object)("can't find any module to process " + assertion.getName() + " type assertions"));
                    continue;
                }
                if (!this.canSupportAssertion(assertion, moduleList)) {
                    throw new AxisFault("atleast one module can't support " + assertion.getName());
                }
                if (namespaceList.contains(namespaceURI)) continue;
                namespaceList.add(namespaceURI);
                modulesToEngage.addAll(moduleList);
            }
            this.engageModulesToAxisDescription(modulesToEngage, this);
        }
        Iterator children = this.getChildren();
        while (children.hasNext()) {
            AxisDescription child = (AxisDescription)children.next();
            child.applyPolicy();
        }
    }

    private boolean canSupportAssertion(Assertion assertion, List moduleList) {
        Iterator iterator = moduleList.iterator();
        while (iterator.hasNext()) {
            AxisModule axisModule = (AxisModule)iterator.next();
            Module module = axisModule.getModule();
            if (module == null || module.canSupportAssertion(assertion)) continue;
            this.log.debug((Object)(axisModule.getName() + " says it can't support " + assertion.getName()));
            return false;
        }
        return true;
    }

    private void engageModulesToAxisDescription(List moduleList, AxisDescription description) throws AxisFault {
        Iterator iterator = moduleList.iterator();
        while (iterator.hasNext()) {
            AxisModule axisModule = (AxisModule)iterator.next();
            Module module = axisModule.getModule();
            if (module == null || description.isEngaged(axisModule.getName())) continue;
            description.engageModule(axisModule, this.getAxisConfiguration());
            axisModule.getModule().engageNotify(description);
        }
    }

    public AxisConfiguration getAxisConfiguration() {
        if (this instanceof AxisConfiguration) {
            return (AxisConfiguration)this;
        }
        if (this.parent != null) {
            return this.parent.getAxisConfiguration();
        }
        return null;
    }

    public abstract Object getKey();

    public abstract void engageModule(AxisModule var1, AxisConfiguration var2) throws AxisFault;

    public abstract boolean isEngaged(QName var1);
}

