/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.FileSystemConfigurator;
import org.apache.axis2.deployment.URLBasedAxisConfigurator;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.SessionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationContextFactory {
    protected static final Log log = LogFactory.getLog((Class)ConfigurationContextFactory.class);

    public static ConfigurationContext createConfigurationContext(AxisConfigurator axisConfigurator) throws AxisFault {
        AxisConfiguration axisConfig = axisConfigurator.getAxisConfiguration();
        ConfigurationContext configContext = new ConfigurationContext(axisConfig);
        if (axisConfigurator instanceof DeploymentEngine) {
            ((DeploymentEngine)((Object)axisConfigurator)).setConfigContext(configContext);
        }
        ConfigurationContextFactory.setContextPaths(axisConfig, configContext);
        ConfigurationContextFactory.configureTransportSessionManagement(axisConfig);
        ConfigurationContextFactory.init(configContext);
        axisConfigurator.engageGlobalModules();
        axisConfigurator.loadServices();
        ConfigurationContextFactory.addModuleService(configContext);
        ConfigurationContextFactory.initApplicationScopeServices(configContext);
        axisConfig.setStart(true);
        return configContext;
    }

    private static void initApplicationScopeServices(ConfigurationContext configCtx) throws AxisFault {
        Iterator serviceGroups = configCtx.getAxisConfiguration().getServiceGroups();
        while (serviceGroups.hasNext()) {
            AxisServiceGroup axisServiceGroup = (AxisServiceGroup)serviceGroups.next();
            String maxScope = SessionUtils.calculateMaxScopeForServiceGroup(axisServiceGroup);
            if (!"application".equals(maxScope)) continue;
            ServiceGroupContext serviceGroupContext = new ServiceGroupContext(configCtx, axisServiceGroup);
            configCtx.addServiceGroupContextintoApplicatoionScopeTable(serviceGroupContext);
            DependencyManager.initService(serviceGroupContext);
        }
    }

    public static void addModuleService(ConfigurationContext configCtx) throws AxisFault {
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        HashMap modules = axisConfig.getModules();
        if (modules != null && modules.size() > 0) {
            Iterator mpduleItr = modules.values().iterator();
            while (mpduleItr.hasNext()) {
                AxisModule axisModule = (AxisModule)mpduleItr.next();
                Utils.deployModuleServices(axisModule, configCtx);
            }
        }
    }

    private static void configureTransportSessionManagement(AxisConfiguration axisConfig) {
        Parameter manageSession = axisConfig.getParameter("manageTransportSession");
        if (manageSession != null) {
            String value = ((String)manageSession.getValue()).trim();
            axisConfig.setManageTransportSession(Boolean.valueOf(value));
        }
    }

    private static void setContextPaths(AxisConfiguration axisConfig, ConfigurationContext configContext) {
        String restPath;
        Parameter restPathParam;
        String spath;
        Parameter servicePath;
        String cpath;
        Parameter contextPath = axisConfig.getParameter("contextRoot");
        if (contextPath != null && (cpath = ((String)contextPath.getValue()).trim()).length() > 0) {
            configContext.setContextRoot(cpath);
        }
        if ((servicePath = axisConfig.getParameter("servicePath")) != null && (spath = ((String)servicePath.getValue()).trim()).length() > 0) {
            configContext.setServicePath(spath);
        }
        if ((restPathParam = axisConfig.getParameter("restPath")) != null && (restPath = ((String)restPathParam.getValue()).trim()).length() > 0) {
            configContext.setRESTPath(restPath);
        }
    }

    public static ConfigurationContext createConfigurationContextFromFileSystem(String path, String axis2xml) throws AxisFault {
        return ConfigurationContextFactory.createConfigurationContext(new FileSystemConfigurator(path, axis2xml));
    }

    public static ConfigurationContext createConfigurationContextFromURIs(URL axis2xml, URL repositoy) throws AxisFault {
        return ConfigurationContextFactory.createConfigurationContext(new URLBasedAxisConfigurator(axis2xml, repositoy));
    }

    private static void init(ConfigurationContext configContext) throws AxisFault {
        try {
            ConfigurationContextFactory.initModules(configContext);
            ConfigurationContextFactory.initTransportSenders(configContext);
        }
        catch (DeploymentException e) {
            throw new AxisFault(e);
        }
    }

    private static void initModules(ConfigurationContext context) throws DeploymentException {
        try {
            HashMap modules = context.getAxisConfiguration().getModules();
            Collection col = modules.values();
            Iterator iterator = col.iterator();
            while (iterator.hasNext()) {
                AxisModule axismodule = (AxisModule)iterator.next();
                Module module = axismodule.getModule();
                if (module == null) continue;
                module.init(context, axismodule);
            }
        }
        catch (AxisFault e) {
            log.info((Object)e.getMessage());
        }
    }

    public static void initTransportSenders(ConfigurationContext configContext) {
        AxisConfiguration axisConf = configContext.getAxisConfiguration();
        HashMap transportOuts = axisConf.getTransportsOut();
        Iterator values = transportOuts.values().iterator();
        while (values.hasNext()) {
            TransportOutDescription transportOut = (TransportOutDescription)values.next();
            TransportSender sender = transportOut.getSender();
            if (sender == null) continue;
            try {
                sender.init(configContext, transportOut);
            }
            catch (AxisFault axisFault) {
                log.info((Object)Messages.getMessage("transportiniterror", transportOut.getName().getLocalPart()));
            }
        }
    }

    public static ConfigurationContext createEmptyConfigurationContext() {
        return new ConfigurationContext(new AxisConfiguration());
    }
}

