/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.metafacades.uml.ActivityGraphFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.EventFacade;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.metafacades.uml.UseCaseFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.omg.uml.UmlPackage;
import org.omg.uml.behavioralelements.activitygraphs.ActivityGraph;
import org.omg.uml.behavioralelements.statemachines.Event;
import org.omg.uml.behavioralelements.statemachines.FinalState;
import org.omg.uml.behavioralelements.usecases.UseCase;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.CorePackage;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.foundation.core.Stereotype;
import org.omg.uml.foundation.core.TaggedValue;
import org.omg.uml.foundation.core.UmlClass;
import org.omg.uml.foundation.datatypes.VisibilityKind;
import org.omg.uml.foundation.datatypes.VisibilityKindEnum;
import org.omg.uml.modelmanagement.Model;

public class UML14MetafacadeUtils {
    private static String empty = "";

    static Object findByFullyQualifiedName(final String fullyQualifiedName, final String separator, final boolean modelName) {
        Collection elements = ((UmlPackage)MetafacadeFactory.getInstance().getModel().getModel()).getCore().getModelElement().refAllOfType();
        Object modelElement = CollectionUtils.find((Collection)elements, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                ModelElement element = (ModelElement)object;
                StringBuilder fullName = new StringBuilder(UML14MetafacadeUtils.getPackageName(element, separator, modelName));
                String name = element.getName();
                if (StringUtils.isNotBlank((String)name)) {
                    String namespaceSeparator = "::";
                    if (!modelName) {
                        namespaceSeparator = separator;
                    }
                    fullName.append(namespaceSeparator);
                    fullName.append(name);
                }
                return fullName.toString().equals(fullyQualifiedName);
            }
        });
        return modelElement;
    }

    static String getPackageName(ModelElement metaObject, String separator, boolean modelName) {
        String packageName = empty;
        Namespace namespace = metaObject.getNamespace();
        while (namespace instanceof org.omg.uml.modelmanagement.UmlPackage && !(namespace instanceof Model)) {
            packageName = packageName.equals(empty) ? namespace.getName() : namespace.getName() + separator + packageName;
            namespace = namespace.getNamespace();
        }
        if (modelName && StringUtils.isNotBlank((String)packageName)) {
            packageName = StringUtils.replace((String)packageName, (String)separator, (String)"::");
        }
        return packageName;
    }

    static CorePackage getCorePackage() {
        return ((UmlPackage)MetafacadeFactory.getInstance().getModel().getModel()).getCore();
    }

    static Object findByName(final String name) {
        Object modelElement = null;
        if (StringUtils.isNotBlank((String)name)) {
            modelElement = CollectionUtils.find((Collection)UML14MetafacadeUtils.getModel().getCore().getModelElement().refAllOfType(), (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return StringUtils.trimToEmpty((String)((ModelElement)object).getName()).equals(name);
                }
            });
        }
        return modelElement;
    }

    static org.omg.uml.modelmanagement.UmlPackage getRootPackage() {
        Object result = null;
        Collection rootPackages = UML14MetafacadeUtils.getModel().getModelManagement().getModel().refAllOfType();
        for (Object rootPackage : rootPackages) {
            if (!(rootPackage instanceof ModelElement)) continue;
            result = rootPackage;
            break;
        }
        return result;
    }

    static UmlPackage getModel() {
        return (UmlPackage)MetafacadeFactory.getInstance().getModel().getModel();
    }

    static VisibilityKind getVisibilityKind(String visibility) {
        VisibilityKindEnum visibilityKind = null;
        if ("public".equals(visibility = StringUtils.trimToEmpty((String)visibility))) {
            visibilityKind = VisibilityKindEnum.VK_PUBLIC;
        } else if ("private".equals(visibility)) {
            visibilityKind = VisibilityKindEnum.VK_PRIVATE;
        } else if (StringUtils.isEmpty((String)visibility)) {
            visibilityKind = VisibilityKindEnum.VK_PACKAGE;
        } else if ("protected".equals(visibility)) {
            visibilityKind = VisibilityKindEnum.VK_PROTECTED;
        }
        return visibilityKind;
    }

    static Attribute createAttribute(String name, String fullyQualifiedTypeName, String visibility, String separator) {
        Attribute attribute = UML14MetafacadeUtils.getCorePackage().getAttribute().createAttribute();
        attribute.setName(name);
        attribute.setVisibility(UML14MetafacadeUtils.getVisibilityKind(visibility));
        Object type = UML14MetafacadeUtils.findByFullyQualifiedName(fullyQualifiedTypeName, separator, false);
        if (type != null && Classifier.class.isAssignableFrom(type.getClass())) {
            attribute.setType((Classifier)type);
        }
        return attribute;
    }

    static boolean attributeExists(Object classifier, String name) {
        boolean exists;
        block1: {
            Object feature;
            List features;
            exists = false;
            if (!Classifier.class.isAssignableFrom(classifier.getClass()) || (features = ((Classifier)classifier).getFeature()) == null || features.isEmpty()) break block1;
            Iterator featureIterator = features.iterator();
            while (!(!featureIterator.hasNext() || (feature = featureIterator.next()) != null && Attribute.class.isAssignableFrom(feature.getClass()) && (exists = StringUtils.trimToEmpty((String)((Attribute)feature).getName()).equals(name)))) {
            }
        }
        return exists;
    }

    static Stereotype findOrCreateStereotype(String name) {
        Object stereotype = UML14MetafacadeUtils.findByName(name);
        if (stereotype == null || !Stereotype.class.isAssignableFrom(stereotype.getClass())) {
            stereotype = UML14MetafacadeUtils.getCorePackage().getStereotype().createStereotype();
            ((Stereotype)stereotype).setName(name);
        }
        return (Stereotype)stereotype;
    }

    static UseCase findFirstUseCaseWithName(String name) {
        return UML14MetafacadeUtils.findFirstUseCaseWithNameAndStereotype(name, null);
    }

    static UseCase findFirstUseCaseWithNameAndStereotype(String name, String stereotypeName) {
        UseCase useCaseWithNameAndStereotype = null;
        Collection useCases = UML14MetafacadeUtils.getModel().getUseCases().getUseCase().refAllOfType();
        Iterator useCaseIterator = useCases.iterator();
        while (useCaseIterator.hasNext() && useCaseWithNameAndStereotype == null) {
            UseCase useCase = (UseCase)useCaseIterator.next();
            if (!name.equals(useCase.getName()) || stereotypeName != null && !UML14MetafacadeUtils.isStereotypePresent((ModelElement)useCase, stereotypeName)) continue;
            useCaseWithNameAndStereotype = useCase;
        }
        return useCaseWithNameAndStereotype;
    }

    static ActivityGraph findFirstActivityGraphWithName(String name) {
        return UML14MetafacadeUtils.findFirstActivityGraphWithNameAndStereotype(name, null);
    }

    static ActivityGraph findFirstActivityGraphWithNameAndStereotype(String name, String stereotypeName) {
        ActivityGraph graphWithNameAndStereotype = null;
        Collection graphs = UML14MetafacadeUtils.getModel().getActivityGraphs().getActivityGraph().refAllOfType();
        Iterator graphIterator = graphs.iterator();
        while (graphIterator.hasNext() && graphWithNameAndStereotype == null) {
            ActivityGraph graph = (ActivityGraph)graphIterator.next();
            if (!name.equals(graph.getName()) || stereotypeName != null && !UML14MetafacadeUtils.isStereotypePresent((ModelElement)graph, stereotypeName)) continue;
            graphWithNameAndStereotype = graph;
        }
        return graphWithNameAndStereotype;
    }

    static boolean isTagPresent(ModelElement element, String tag, Object value) {
        boolean tagPresent = false;
        Collection taggedValues = element.getTaggedValue();
        Iterator taggedValueIterator = taggedValues.iterator();
        while (taggedValueIterator.hasNext() && !tagPresent) {
            TaggedValue taggedValue = (TaggedValue)taggedValueIterator.next();
            String tagName = taggedValue.getName();
            if (!tag.equals(tagName) && !MetafacadeUtils.getEmfTaggedValue((String)tag).equals(tagName) && !MetafacadeUtils.getUml14TaggedValue((String)tag).equals(tagName)) continue;
            Iterator valueIterator = taggedValue.getDataValue().iterator();
            while (valueIterator.hasNext() && !tagPresent) {
                Object dataValue = valueIterator.next();
                if (!value.equals(dataValue)) continue;
                tagPresent = true;
            }
            valueIterator = taggedValue.getReferenceValue().iterator();
            while (valueIterator.hasNext() && !tagPresent) {
                Object referenceValue = valueIterator.next();
                if (!value.equals(referenceValue)) continue;
                tagPresent = true;
            }
        }
        return tagPresent;
    }

    static boolean isHyperlinkPresent(ModelElement element, Object value) {
        return UML14MetafacadeUtils.isTagPresent(element, "hyperlinkModel", value);
    }

    static boolean isStereotypePresent(ModelElement element, String stereotypeName) {
        boolean stereotypePresent = false;
        Collection stereotypes = element.getStereotype();
        Iterator stereotypeIterator = stereotypes.iterator();
        while (stereotypeIterator.hasNext() && !stereotypePresent) {
            Stereotype stereotype = (Stereotype)stereotypeIterator.next();
            if (!stereotypeName.equals(stereotype.getName())) continue;
            stereotypePresent = true;
        }
        return stereotypePresent;
    }

    static UseCase findUseCaseWithTaggedValueOrHyperlink(String tag, String value) {
        UseCase useCaseWithTaggedValue = null;
        Collection useCases = UML14MetafacadeUtils.getModel().getUseCases().getUseCase().refAllOfType();
        Iterator useCaseIterator = useCases.iterator();
        while (useCaseIterator.hasNext() && useCaseWithTaggedValue == null) {
            UseCase useCase = (UseCase)useCaseIterator.next();
            if (!UML14MetafacadeUtils.isTagPresent((ModelElement)useCase, tag, value) && !UML14MetafacadeUtils.isHyperlinkPresent((ModelElement)useCase, value)) continue;
            useCaseWithTaggedValue = useCase;
        }
        return useCaseWithTaggedValue;
    }

    static UmlClass findClassWithTaggedValueOrHyperlink(String tag, String value) {
        UmlClass classWithTaggedValue = null;
        Collection classes = UML14MetafacadeUtils.getModel().getCore().getUmlClass().refAllOfType();
        Iterator classIterator = classes.iterator();
        while (classIterator.hasNext() && classWithTaggedValue == null) {
            UmlClass clazz = (UmlClass)classIterator.next();
            if (!UML14MetafacadeUtils.isTagPresent((ModelElement)clazz, tag, value) && !UML14MetafacadeUtils.isHyperlinkPresent((ModelElement)clazz, value)) continue;
            classWithTaggedValue = clazz;
        }
        return classWithTaggedValue;
    }

    static Collection<FinalState> findFinalStatesWithNameOrHyperlink(UseCase useCase) {
        ArrayList<FinalState> finalStates = new ArrayList<FinalState>();
        if (useCase != null && useCase.getName() != null) {
            String useCaseName = useCase.getName();
            Collection allFinalStates = UML14MetafacadeUtils.getModel().getStateMachines().getFinalState().refAllOfType();
            for (FinalState finalState : allFinalStates) {
                if (useCaseName != null) {
                    if (useCaseName.equals(finalState.getName())) {
                        finalStates.add(finalState);
                        continue;
                    }
                    if (!UML14MetafacadeUtils.isHyperlinkPresent((ModelElement)finalState, useCase)) continue;
                    finalStates.add(finalState);
                    continue;
                }
                if (!UML14MetafacadeUtils.isHyperlinkPresent((ModelElement)finalState, useCase)) continue;
                finalStates.add(finalState);
            }
        }
        return finalStates;
    }

    static ActivityGraph getMetaClass(ActivityGraphFacade facade) {
        ActivityGraph activityGraph = null;
        if (facade != null) {
            String id = facade.getId();
            Collection graphs = UML14MetafacadeUtils.getModel().getActivityGraphs().getActivityGraph().refAllOfType();
            Iterator iterator = graphs.iterator();
            while (iterator.hasNext() && activityGraph == null) {
                ModelElement element = (ModelElement)iterator.next();
                if (!id.equals(element.refMofId())) continue;
                activityGraph = (ActivityGraph)element;
            }
        }
        return activityGraph;
    }

    static UseCase getMetaClass(UseCaseFacade facade) {
        UseCase useCase = null;
        if (facade != null) {
            String id = facade.getId();
            Collection useCases = UML14MetafacadeUtils.getModel().getUseCases().getUseCase().refAllOfType();
            Iterator iterator = useCases.iterator();
            while (iterator.hasNext() && useCase == null) {
                ModelElement element = (ModelElement)iterator.next();
                if (!id.equals(element.refMofId())) continue;
                useCase = (UseCase)element;
            }
        }
        return useCase;
    }

    static Parameter getMetaClass(ParameterFacade facade) {
        Parameter parameter = null;
        if (facade != null) {
            String id = facade.getId();
            Collection parameters = UML14MetafacadeUtils.getModel().getCore().getParameter().refAllOfType();
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext() && parameter == null) {
                ModelElement element = (ModelElement)iterator.next();
                if (!id.equals(element.refMofId())) continue;
                parameter = (Parameter)element;
            }
        }
        return parameter;
    }

    static Event getMetaClass(EventFacade facade) {
        Event event = null;
        if (facade != null) {
            String id = facade.getId();
            Collection events = UML14MetafacadeUtils.getModel().getStateMachines().getEvent().refAllOfType();
            Iterator iterator = events.iterator();
            while (iterator.hasNext() && event == null) {
                ModelElement element = (ModelElement)iterator.next();
                if (!id.equals(element.refMofId())) continue;
                event = (Event)element;
            }
        }
        return event;
    }

    static ModelElement getMetaClass(ModelElementFacade facade) {
        ModelElement modelElement = null;
        if (facade != null) {
            String id = facade.getId();
            Collection modelElements = UML14MetafacadeUtils.getModel().getCore().getModelElement().refAllOfType();
            Iterator iterator = modelElements.iterator();
            while (iterator.hasNext() && modelElement == null) {
                ModelElement element = (ModelElement)iterator.next();
                if (!id.equals(element.refMofId())) continue;
                modelElement = element;
            }
        }
        return modelElement;
    }

    public static String getSerialVersionUID(ClassifierFacade classifier) {
        ExceptionUtils.checkNull((String)"classifer", (Object)classifier);
        String serialVersionString = (String)classifier.findTaggedValue(UMLProfile.TAGGEDVALUE_SERIALVERSION_UID);
        return StringUtils.trimToNull((String)serialVersionString);
    }

    public static List<ModelElementFacade> removeDuplicatesAndCopyTaggedValues(Collection<ModelElementFacade> elements) {
        LinkedHashMap<String, ModelElementFacade> map = new LinkedHashMap<String, ModelElementFacade>();
        if (elements != null) {
            for (ModelElementFacade element : elements) {
                String name = element.getName();
                ModelElementFacade existingVariable = (ModelElementFacade)map.get(name);
                if (existingVariable != null) {
                    element.copyTaggedValues(existingVariable);
                }
                map.put(name, element);
            }
        }
        return new ArrayList<ModelElementFacade>(map.values());
    }
}

