/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.Collection;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.Entity;
import org.andromda.metafacades.uml.EntityAssociationEnd;
import org.andromda.metafacades.uml.EntityAttribute;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.metafacades.uml14.EntityAssociationEndLogic;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EntityAssociationEndLogicImpl
extends EntityAssociationEndLogic {
    private static final long serialVersionUID = 34L;
    private static final Logger logger = Logger.getLogger(EntityAssociationEndLogicImpl.class);

    public EntityAssociationEndLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("entityPropertyNameMask"));
        return NameMasker.mask((String)super.handleGetName(), (String)nameMask);
    }

    @Override
    public String handleGetColumnName() {
        String columnName = null;
        if (this.getType() instanceof Entity) {
            String columnNamePrefix = this.isConfiguredProperty("columnNamePrefix") ? ObjectUtils.toString((Object)this.getConfiguredProperty("columnNamePrefix")) : null;
            String columnNameSuffix = this.isConfiguredProperty("columnNameSuffix") ? ObjectUtils.toString((Object)this.getConfiguredProperty("columnNameSuffix")) : "";
            columnName = EntityMetafacadeUtils.getSqlNameFromTaggedValue((String)columnNamePrefix, (ModelElementFacade)this, (String)UMLProfile.TAGGEDVALUE_PERSISTENCE_COLUMN, (Short)((Entity)this.getType()).getMaxSqlNameLength(), (String)(columnNameSuffix + this.getForeignKeySuffix()), (Object)this.getConfiguredProperty("sqlNameSeparator"));
        }
        return columnName;
    }

    @Override
    public String handleGetForeignKeySuffix() {
        return (String)this.getConfiguredProperty("foreignKeySuffix");
    }

    @Override
    protected boolean handleIsForeignIdentifier() {
        Object value = this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_FOREIGN_IDENTIFIER);
        return value != null && Boolean.valueOf(String.valueOf(value)) != false;
    }

    @Override
    protected String handleGetForeignKeyConstraintName() {
        return EntityMetafacadeUtils.getForeignKeyConstraintName((EntityAssociationEnd)((EntityAssociationEnd)this.THIS()), (String)ObjectUtils.toString((Object)this.getConfiguredProperty("constraintSuffix")).trim(), (String)ObjectUtils.toString((Object)this.getConfiguredProperty("sqlNameSeparator")).trim(), (String)ObjectUtils.toString((Object)this.getConfiguredProperty("maxSqlNameLength")).trim());
    }

    @Override
    public String handleGetColumnIndex() {
        String index = (String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_COLUMN_INDEX);
        return index != null ? StringUtils.trimToEmpty((String)index) : null;
    }

    @Override
    protected String handleGetSqlType() {
        String value = null;
        if (this.getSqlMappings() != null) {
            AttributeFacade attribute;
            Entity type;
            Collection identifiers;
            EntityAttribute identifier = null;
            if (this.getType() instanceof Entity && (identifiers = (type = (Entity)this.getType()).getIdentifiers()) != null && !identifiers.isEmpty() && (attribute = (AttributeFacade)identifiers.iterator().next()) instanceof EntityAttribute) {
                identifier = (EntityAttribute)attribute;
            }
            if (identifier != null && identifier.getType() != null) {
                String typeName = identifier.getType().getFullyQualifiedName(true);
                value = this.getSqlMappings().getTo(typeName);
                String columnLength = identifier.getColumnLength();
                if (StringUtils.isNotBlank((String)columnLength)) {
                    value = EntityMetafacadeUtils.constructSqlTypeName((String)value, (String)columnLength);
                }
            }
        }
        return value;
    }

    public TypeMappings getSqlMappings() {
        String propertyName = "sqlMappingsUri";
        Object property = this.getConfiguredProperty("sqlMappingsUri");
        TypeMappings mappings = null;
        if (property instanceof String) {
            String uri = (String)property;
            try {
                mappings = TypeMappings.getInstance((String)uri);
                this.setProperty("sqlMappingsUri", mappings);
            }
            catch (Throwable throwable) {
                logger.error((Object)("Error getting 'sqlMappingsUri' --> '" + uri + '\''), throwable);
            }
        } else {
            mappings = (TypeMappings)property;
        }
        return mappings;
    }

    @Override
    protected boolean handleIsTransient() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_TRANSIENT);
    }

    @Override
    protected boolean handleIsIdentifiersPresent() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_IDENTIFIER);
    }

    @Override
    protected String handleGetUniqueGroup() {
        String group = (String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_ASSOCIATION_END_UNIQUE_GROUP);
        return group != null ? StringUtils.trimToEmpty((String)group) : null;
    }

    protected boolean handleIsIdentifier() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_IDENTIFIER);
    }
}

