/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.andromda.metafacades.emf.uml22.OperationFacadeLogic;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.ConstraintFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.CallConcurrencyKind;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;

public class OperationFacadeLogicImpl
extends OperationFacadeLogic {
    private static final long serialVersionUID = 34L;
    private static final Logger LOGGER = Logger.getLogger(OperationFacadeLogicImpl.class);

    public OperationFacadeLogicImpl(Operation metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetMethodBody() {
        return null;
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("operationNameMask"));
        return NameMasker.mask((String)super.handleGetName(), (String)nameMask);
    }

    @Override
    protected String handleGetSignature() {
        return this.getSignature(true);
    }

    @Override
    protected String handleGetCall() {
        return this.getCall(this.handleGetName());
    }

    private String getCall(String name) {
        StringBuilder buffer = new StringBuilder(name);
        buffer.append('(');
        buffer.append(this.getArgumentNames());
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected String handleGetTypedArgumentList() {
        return this.getTypedArgumentList(true);
    }

    private String getTypedArgumentList(boolean withArgumentNames) {
        return MetafacadeUtils.getTypedArgumentList(this.getArguments(), (boolean)withArgumentNames, null);
    }

    @Override
    protected boolean handleIsStatic() {
        return this.metaObject.isStatic();
    }

    @Override
    protected boolean handleIsAbstract() {
        return this.metaObject.isAbstract();
    }

    @Override
    protected String handleGetExceptionList() {
        return this.getExceptionList(null);
    }

    @Override
    protected Collection handleGetExceptions() {
        final class ExceptionFilter
        implements Predicate {
            ExceptionFilter() {
            }

            public boolean evaluate(Object object) {
                DependencyFacade dependency;
                boolean hasException = object instanceof DependencyFacade;
                if (hasException && !(hasException = (dependency = (DependencyFacade)object).hasStereotype(UMLProfile.STEREOTYPE_EXCEPTION_REF))) {
                    ModelElementFacade targetElement = dependency.getTargetElement();
                    hasException = targetElement != null && targetElement.hasStereotype(UMLProfile.STEREOTYPE_EXCEPTION);
                }
                return hasException;
            }
        }
        ArrayList<DependencyFacade> operationDependencies;
        LinkedHashSet exceptions = new LinkedHashSet();
        ArrayList ownerDependencies = new ArrayList(this.getOwner().getSourceDependencies());
        if (!ownerDependencies.isEmpty()) {
            CollectionUtils.filter(ownerDependencies, (Predicate)new ExceptionFilter());
            exceptions.addAll(ownerDependencies);
        }
        if (!(operationDependencies = new ArrayList<DependencyFacade>(this.getSourceDependencies())).isEmpty()) {
            CollectionUtils.filter(operationDependencies, (Predicate)new ExceptionFilter());
            exceptions.addAll(operationDependencies);
        }
        CollectionUtils.transform(exceptions, (Transformer)new Transformer(){

            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return ((DependencyFacade)object).getTargetElement();
            }
        });
        EList raisedExceptions = this.metaObject.getRaisedExceptions();
        exceptions.addAll(this.shieldedElements((Collection)raisedExceptions));
        return exceptions;
    }

    @Override
    protected boolean handleIsReturnTypePresent() {
        boolean hasReturnType = false;
        if (this.getReturnType() != null) {
            boolean bl = hasReturnType = !"void".equalsIgnoreCase(StringUtils.trimToEmpty((String)this.getReturnType().getFullyQualifiedName())) && !StringUtils.trimToEmpty((String)this.getReturnType().getFullyQualifiedName(true)).equals(UMLProfile.VOID_TYPE_NAME);
        }
        if (LOGGER.isDebugEnabled()) {
            String rtnFQN = this.getReturnType().getFullyQualifiedName(true);
            boolean voidType = "void".equalsIgnoreCase(StringUtils.trimToEmpty((String)this.getReturnType().getFullyQualifiedName()));
            String voidRtn = this.getReturnType().getFullyQualifiedName();
            LOGGER.debug((Object)("OperationFacadeLogicImpl.handleIsReturnTypePresent rtnFQN=" + rtnFQN + " voidType=" + voidType + " voidRtn=" + voidRtn + " hasReturnType=" + hasReturnType));
        }
        return hasReturnType;
    }

    @Override
    protected boolean handleIsExceptionsPresent() {
        return !this.getExceptions().isEmpty();
    }

    @Override
    protected String handleGetArgumentNames() {
        StringBuilder buffer = new StringBuilder();
        Iterator iterator = this.metaObject.getOwnedParameters().iterator();
        boolean commaNeeded = false;
        String comma = ", ";
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)) continue;
            if (commaNeeded) {
                buffer.append(", ");
            }
            ParameterFacade facade = (ParameterFacade)this.shieldedElement(parameter);
            buffer.append(facade.getName());
            commaNeeded = true;
        }
        return buffer.toString();
    }

    @Override
    protected String handleGetArgumentTypeNames() {
        StringBuilder buffer = new StringBuilder();
        Iterator iterator = this.metaObject.getOwnedParameters().iterator();
        boolean commaNeeded = false;
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)) continue;
            if (commaNeeded) {
                buffer.append(", ");
            }
            ParameterFacade facade = (ParameterFacade)this.shieldedElement(parameter);
            buffer.append(facade.getType().getFullyQualifiedName());
            commaNeeded = true;
        }
        return buffer.toString();
    }

    @Override
    protected boolean handleIsQuery() {
        return this.metaObject.isQuery();
    }

    @Override
    protected String handleGetConcurrency() {
        String concurrency = null;
        CallConcurrencyKind concurrencyKind = this.metaObject.getConcurrency();
        concurrency = concurrencyKind == null || concurrencyKind.equals((Object)CallConcurrencyKind.CONCURRENT_LITERAL) ? "concurrent" : (concurrencyKind.equals((Object)CallConcurrencyKind.GUARDED_LITERAL) ? "guarded" : "sequential");
        TypeMappings languageMappings = this.getLanguageMappings();
        if (languageMappings != null) {
            concurrency = languageMappings.getTo(concurrency);
        }
        return concurrency;
    }

    private String getPreconditionPattern() {
        return String.valueOf(this.getConfiguredProperty("preconditionNamePattern"));
    }

    private String getPostconditionPattern() {
        return String.valueOf(this.getConfiguredProperty("postconditionNamePattern"));
    }

    @Override
    protected String handleGetPreconditionName() {
        return this.getPreconditionPattern().replaceAll("\\{0\\}", this.handleGetName());
    }

    @Override
    protected String handleGetPostconditionName() {
        return this.getPostconditionPattern().replaceAll("\\{0\\}", this.handleGetName());
    }

    @Override
    protected String handleGetPreconditionSignature() {
        return MetafacadeUtils.getSignature((String)this.getPreconditionName(), this.getArguments(), (boolean)true, null);
    }

    @Override
    protected String handleGetPreconditionCall() {
        return this.getCall(this.getPreconditionName());
    }

    @Override
    protected boolean handleIsPreconditionsPresent() {
        Collection<ConstraintFacade> preconditions = this.getPreconditions();
        return preconditions != null && !preconditions.isEmpty();
    }

    @Override
    protected boolean handleIsPostconditionsPresent() {
        Collection<ConstraintFacade> postconditions = this.getPostconditions();
        return postconditions != null && !postconditions.isEmpty();
    }

    @Override
    protected Object handleFindTaggedValue(String name, boolean follow) {
        String trimName = StringUtils.trimToEmpty((String)name);
        Object value = this.findTaggedValue(trimName);
        if (follow) {
            for (ClassifierFacade type = this.getReturnType(); value == null && type != null; type = (ClassifierFacade)type.getGeneralization()) {
                value = type.findTaggedValue(trimName);
            }
        }
        return value;
    }

    @Override
    protected String handleGetExceptionList(String initialExceptions) {
        initialExceptions = StringUtils.trimToEmpty((String)initialExceptions);
        StringBuilder exceptionList = new StringBuilder(initialExceptions);
        Collection exceptions = this.getExceptions();
        if (exceptions != null && !exceptions.isEmpty()) {
            if (StringUtils.isNotBlank((String)initialExceptions)) {
                exceptionList.append(", ");
            }
            Iterator exceptionIt = exceptions.iterator();
            while (exceptionIt.hasNext()) {
                ModelElementFacade exception = (ModelElementFacade)exceptionIt.next();
                exceptionList.append(exception.getFullyQualifiedName());
                if (!exceptionIt.hasNext()) continue;
                exceptionList.append(", ");
            }
        }
        return exceptionList.toString();
    }

    @Override
    protected String handleGetSignature(boolean withArgumentNames) {
        return MetafacadeUtils.getSignature((String)this.handleGetName(), this.getArguments(), (boolean)withArgumentNames, null);
    }

    @Override
    protected String handleGetTypedArgumentList(String modifier) {
        return MetafacadeUtils.getTypedArgumentList(this.getArguments(), (boolean)true, (String)modifier);
    }

    @Override
    protected String handleGetSignature(String argumentModifier) {
        return MetafacadeUtils.getSignature((String)this.handleGetName(), this.getArguments(), (boolean)true, (String)argumentModifier);
    }

    @Override
    protected Object handleGetOwner() {
        Object obj = null;
        obj = this.metaObject.getInterface() != null ? this.metaObject.getInterface() : (this.metaObject.getDatatype() != null ? this.metaObject.getDatatype() : this.metaObject.getClass_());
        return obj;
    }

    @Override
    protected Collection<Parameter> handleGetParameters() {
        ArrayList<Parameter> params = new ArrayList<Parameter>((Collection<Parameter>)this.metaObject.getOwnedParameters());
        params.add(this.metaObject.getReturnResult());
        CollectionUtils.filter(params, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object != null && !((Parameter)object).isException();
            }
        });
        return params;
    }

    protected Type handleGetReturnType() {
        return this.metaObject.getType();
    }

    @Override
    protected String handleGetGetterSetterReturnTypeName() {
        String name = null;
        ClassifierFacade returnType = this.getReturnType();
        if (returnType != null && (this.getUpper() > 1 || this.getUpper() == -1)) {
            TypeMappings mappings = this.getLanguageMappings();
            String string = name = this.handleIsOrdered() ? mappings.getTo(UMLProfile.LIST_TYPE_NAME) : mappings.getTo(UMLProfile.COLLECTION_TYPE_NAME);
            if (BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)this.getConfiguredProperty("enableTemplating")))) {
                String type = returnType.getFullyQualifiedName();
                if (returnType.isPrimitive()) {
                    type = this.getReturnType().getWrapperName();
                }
                name = name + '<' + type + '>';
            }
        }
        if (name == null && returnType != null) {
            name = returnType.getFullyQualifiedName();
            if (this.getReturnType().isBooleanType()) {
                if (this.getReturnType().isPrimitive() && this.getLower() < 1) {
                    name = StringUtils.capitalize((String)name);
                } else if (!this.getReturnType().isPrimitive() && this.getLower() > 0) {
                    name = StringUtils.uncapitalize((String)name);
                }
            }
        }
        return name;
    }

    @Override
    protected boolean handleIsOrdered() {
        return this.metaObject.isOrdered();
    }

    @Override
    protected boolean handleIsMany() {
        ParameterFacade returnParameter = this.getReturnParameter();
        boolean returnMany = returnParameter != null && returnParameter.getType() != null && (returnParameter.getUpper() > 1 || returnParameter.getUpper() == -1 || returnParameter.getType().isArrayType());
        return returnMany || this.getUpper() > 1 || this.getUpper() == -1;
    }

    @Override
    protected Collection<Parameter> handleGetArguments() {
        ArrayList<Parameter> arguments = new ArrayList<Parameter>((Collection<Parameter>)this.metaObject.getOwnedParameters());
        CollectionUtils.filter(arguments, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Parameter param = (Parameter)object;
                return !param.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL) && !param.isException();
            }
        });
        return arguments;
    }

    @Override
    protected Collection<ConstraintFacade> handleGetPreconditions() {
        return this.handleGetConstraints("pre");
    }

    @Override
    protected Collection<ConstraintFacade> handleGetPostconditions() {
        return this.handleGetConstraints("post");
    }

    public Object getValidationOwner() {
        return this.getOwner();
    }

    @Override
    protected ParameterFacade handleFindParameter(String name) {
        return (ParameterFacade)this.shieldedElement(this.metaObject.getOwnedParameter(name, null));
    }

    @Override
    protected int handleGetUpper() {
        return this.metaObject.getUpper();
    }

    @Override
    protected int handleGetLower() {
        return this.metaObject.getLower();
    }

    @Override
    public ParameterFacade handleGetReturnParameter() {
        return (ParameterFacade)this.shieldedElement(this.metaObject.getReturnResult());
    }

    @Override
    protected String handleGetVisibility() {
        String visibility = super.handleGetVisibility();
        if (visibility == null || visibility.equals("private")) {
            visibility = "public";
        }
        return visibility;
    }

    @Override
    protected boolean handleIsOverriding() {
        return this.getOverriddenOperation() != null;
    }

    protected OperationFacade handleGetOverriddenOperation() {
        OperationFacade overriddenOperation = null;
        String signature = this.getSignature(false);
        for (ClassifierFacade ancestor = this.getOwner().getSuperClass(); overriddenOperation == null && ancestor != null; ancestor = ancestor.getSuperClass()) {
            Iterator operationIterator = ancestor.getOperations().iterator();
            while (overriddenOperation == null && operationIterator.hasNext()) {
                OperationFacade ancestorOperation = (OperationFacade)operationIterator.next();
                if (!signature.equals(ancestorOperation.getSignature(false))) continue;
                overriddenOperation = ancestorOperation;
            }
        }
        return overriddenOperation;
    }

    @Override
    protected boolean handleIsLeaf() {
        return this.metaObject.isLeaf();
    }

    @Override
    protected boolean handleIsUnique() {
        return this.metaObject.isUnique();
    }
}

