/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.andromda.metafacades.emf.uml22.ManageableEntityLogic;
import org.andromda.metafacades.uml.ActorFacade;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.Entity;
import org.andromda.metafacades.uml.EntityAttribute;
import org.andromda.metafacades.uml.ManageableEntity;
import org.andromda.metafacades.uml.ManageableEntityAssociationEnd;
import org.andromda.metafacades.uml.ManageableEntityAttribute;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class ManageableEntityLogicImpl
extends ManageableEntityLogic {
    private static final long serialVersionUID = 3824640154861250348L;

    public ManageableEntityLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    private String getNamespaceSeparator() {
        return (String)this.getConfiguredProperty("namespaceSeparator");
    }

    @Override
    protected String handleGetManageablePackageName() {
        Object suffix;
        String manageablePackageName = "";
        String parentPackage = super.getPackageName();
        if (StringUtils.isNotBlank((String)parentPackage)) {
            manageablePackageName = parentPackage;
        }
        if ((suffix = this.getConfiguredProperty("manageablePackageSuffix")) != null && StringUtils.isNotBlank((String)suffix.toString())) {
            manageablePackageName = manageablePackageName + this.getNamespaceSeparator() + suffix;
        }
        return manageablePackageName;
    }

    @Override
    protected String handleGetManageablePackagePath() {
        return StringUtils.replace((String)this.getManageablePackageName(), (String)this.getNamespaceSeparator(), (String)"/");
    }

    @Override
    protected List<AssociationEndFacade> handleGetManageableAssociationEnds() {
        LinkedHashSet<AssociationEndFacade> manageableAssociationEnds = new LinkedHashSet<AssociationEndFacade>();
        ManageableEntityLogicImpl.collectAssociationEnds(manageableAssociationEnds, this);
        return new ArrayList<AssociationEndFacade>(manageableAssociationEnds);
    }

    private static void collectAssociationEnds(Collection<AssociationEndFacade> manageableAssociationEnds, ManageableEntity entity) {
        List associationEnds = entity.getAssociationEnds();
        for (AssociationEndFacade associationEnd : associationEnds) {
            AssociationEndFacade otherEnd = associationEnd.getOtherEnd();
            if (!otherEnd.isNavigable() || !(otherEnd.getType() instanceof Entity)) continue;
            manageableAssociationEnds.add(otherEnd);
        }
        Collection parentEntities = entity.getAllGeneralizations();
        for (Object parentEntityObject : parentEntities) {
            if (!(parentEntityObject instanceof ManageableEntity)) continue;
            ManageableEntityLogicImpl.collectAssociationEnds(manageableAssociationEnds, (ManageableEntity)parentEntityObject);
        }
    }

    @Override
    protected boolean handleIsCreate() {
        return !this.isAbstract();
    }

    @Override
    protected String handleGetManageableServiceName() {
        return this.handleGetName() + "ManageableService";
    }

    @Override
    protected String handleGetManageableServiceFullPath() {
        return '/' + StringUtils.replace((String)this.getFullyQualifiedManageableServiceName(), (String)this.getNamespaceSeparator(), (String)"/");
    }

    @Override
    protected String handleGetFullyQualifiedManageableServiceName() {
        return this.getManageablePackageName() + this.getNamespaceSeparator() + this.getManageableServiceName();
    }

    @Override
    protected String handleGetManageableServiceAccessorCall() {
        String property = "manageableServiceAccessorPattern";
        String accessorImplementation = this.isConfiguredProperty("manageableServiceAccessorPattern") ? ObjectUtils.toString((Object)this.getConfiguredProperty("manageableServiceAccessorPattern")) : "${application.package}.ManageableServiceLocator.instance().get{1}()";
        return accessorImplementation.replaceAll("\\{0\\}", this.getManageablePackageName()).replaceAll("\\{1\\}", this.getManageableServiceName());
    }

    @Override
    protected boolean handleIsRead() {
        return true;
    }

    @Override
    protected boolean handleIsUpdate() {
        return this.getManageableIdentifier() != null;
    }

    @Override
    protected boolean handleIsDelete() {
        return this.getManageableIdentifier() != null;
    }

    @Override
    protected List<AttributeFacade> handleGetManageableAttributes() {
        return new ArrayList<AttributeFacade>(this.getAttributes(true));
    }

    @Override
    protected Object handleGetManageableIdentifier() {
        return this.getIdentifiers(true).iterator().next();
    }

    @Override
    protected List<ModelElementFacade> handleGetManageableMembers() {
        ArrayList<ModelElementFacade> criteria = new ArrayList<ModelElementFacade>();
        criteria.addAll(this.getManageableAttributes());
        criteria.addAll(this.getManageableAssociationEnds());
        return criteria;
    }

    private String createListWithManageableMembers(ListType listType) {
        StringBuilder buffer = new StringBuilder();
        for (ManageableEntityAttribute attribute : this.getManageableAttributes()) {
            ClassifierFacade type;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            if ((type = attribute.getType()) == null) continue;
            if (ListType.PRIMITIVE.equals((Object)listType)) {
                buffer.append(type.getFullyQualifiedName());
                buffer.append(' ');
            } else if (ListType.WRAPPER.equals((Object)listType)) {
                buffer.append(type.isPrimitive() ? type.getWrapperName() : type.getFullyQualifiedName());
                buffer.append(' ');
            }
            buffer.append(attribute.getName());
        }
        for (ManageableEntityAssociationEnd associationEnd : this.getManageableAssociationEnds()) {
            Entity entity = (Entity)associationEnd.getType();
            if (entity.isCompositeIdentifier()) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                if (listType != null) {
                    buffer.append("Object");
                    if (associationEnd.isMany()) {
                        buffer.append("[]");
                    }
                    buffer.append(' ');
                }
                buffer.append(associationEnd.getName());
                continue;
            }
            for (EntityAttribute identifier : entity.getIdentifiers()) {
                ClassifierFacade type;
                if (identifier == null) continue;
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                if ((type = identifier.getType()) == null) continue;
                if (listType != null) {
                    buffer.append(type.getFullyQualifiedName());
                    if (associationEnd.isMany()) {
                        buffer.append("[]");
                    }
                    buffer.append(' ');
                }
                buffer.append(associationEnd.getName());
            }
        }
        return buffer.toString();
    }

    @Override
    protected String handleListManageableMembersWithWrapperTypes() {
        return this.createListWithManageableMembers(ListType.WRAPPER);
    }

    @Override
    protected String handleListManageableMembers(boolean withTypes) {
        return this.createListWithManageableMembers(withTypes ? ListType.PRIMITIVE : null);
    }

    @Override
    protected boolean handleIsManageable() {
        return Boolean.valueOf((String)this.getConfiguredProperty("enableManageableEntities"));
    }

    @Override
    protected List<ClassifierFacade> handleGetReferencingManageables() {
        LinkedHashSet<ClassifierFacade> referencingManageables = new LinkedHashSet<ClassifierFacade>();
        List<AssociationEndFacade> associationEnds = this.getAssociationEnds();
        for (AssociationEndFacade associationEnd : associationEnds) {
            ClassifierFacade otherEndType;
            if (!associationEnd.isNavigable() || !associationEnd.isMany() && (!associationEnd.isOne2One() || !associationEnd.isChild()) || !((otherEndType = associationEnd.getOtherEnd().getType()) instanceof Entity)) continue;
            referencingManageables.add(otherEndType);
        }
        return new ArrayList<ClassifierFacade>(referencingManageables);
    }

    protected AttributeFacade handleGetDisplayAttribute() {
        AttributeFacade displayAttribute = null;
        Object taggedValueObject = this.findTaggedValue(UMLProfile.TAGGEDVALUE_MANAGEABLE_DISPLAY_NAME);
        if (taggedValueObject != null) {
            displayAttribute = this.findAttribute(StringUtils.trimToEmpty((String)taggedValueObject.toString()));
        }
        List attributes = this.getAttributes(true);
        Iterator attributeIterator = attributes.iterator();
        while (attributeIterator.hasNext() && displayAttribute == null) {
            EntityAttribute entityAttribute;
            Object attribute = attributeIterator.next();
            if (!(attribute instanceof EntityAttribute) || !(entityAttribute = (EntityAttribute)attribute).isUnique()) continue;
            displayAttribute = entityAttribute;
        }
        if (displayAttribute == null) {
            if (!this.getIdentifiers().isEmpty()) {
                displayAttribute = (AttributeFacade)this.getIdentifiers().iterator().next();
            } else if (!attributes.isEmpty()) {
                displayAttribute = (AttributeFacade)attributes.iterator().next();
            }
        }
        return displayAttribute;
    }

    @Override
    protected List<ActorFacade> handleGetUsers() {
        LinkedHashSet<ActorFacade> users = new LinkedHashSet<ActorFacade>();
        Collection<DependencyFacade> dependencies = this.getTargetDependencies();
        for (DependencyFacade dependency : dependencies) {
            ModelElementFacade dependencyObject = dependency.getSourceElement();
            if (users.contains(dependencyObject) || !(dependencyObject instanceof ActorFacade)) continue;
            this.collectActors((ActorFacade)dependencyObject, users);
        }
        return new ArrayList<ActorFacade>(users);
    }

    private void collectActors(ActorFacade actor, Collection<ActorFacade> actors) {
        if (!actors.contains(actor)) {
            actors.add(actor);
            List childActors = actor.getGeneralizedByActors();
            for (ActorFacade childActor : childActors) {
                this.collectActors(childActor, actors);
            }
        }
    }

    @Override
    protected int handleGetMaximumListSize() {
        int maximumListSize;
        Object taggedValueObject = this.findTaggedValue(UMLProfile.TAGGEDVALUE_MANAGEABLE_MAXIMUM_LIST_SIZE);
        if (taggedValueObject == null) {
            maximumListSize = this.internalDefaultMaximumListSize();
        } else {
            try {
                maximumListSize = Integer.parseInt(taggedValueObject.toString());
            }
            catch (NumberFormatException e) {
                maximumListSize = this.internalDefaultMaximumListSize();
            }
        }
        return maximumListSize;
    }

    private int internalDefaultMaximumListSize() {
        int maximumListSize;
        try {
            maximumListSize = Integer.parseInt((String)this.getConfiguredProperty("defaultMaximumListSize"));
        }
        catch (NumberFormatException e1) {
            maximumListSize = -1;
        }
        return maximumListSize;
    }

    @Override
    protected int handleGetPageSize() {
        int pageSize;
        Object taggedValueObject = this.findTaggedValue(UMLProfile.TAGGEDVALUE_MANAGEABLE_PAGE_SIZE);
        if (taggedValueObject == null) {
            pageSize = this.internalDefaultPageSize();
        } else {
            try {
                pageSize = Integer.parseInt(taggedValueObject.toString());
            }
            catch (NumberFormatException e) {
                pageSize = this.internalDefaultPageSize();
            }
        }
        return pageSize;
    }

    private int internalDefaultPageSize() {
        int pageSize;
        try {
            pageSize = Integer.parseInt((String)this.getConfiguredProperty("defaultPageSize"));
        }
        catch (NumberFormatException e1) {
            pageSize = 20;
        }
        return pageSize;
    }

    @Override
    protected boolean handleIsResolveable() {
        boolean resolveable;
        Object taggedValueObject = this.findTaggedValue(UMLProfile.TAGGEDVALUE_MANAGEABLE_RESOLVEABLE);
        if (taggedValueObject == null) {
            resolveable = this.internalDefaultResolveable();
        } else {
            try {
                resolveable = Boolean.valueOf(taggedValueObject.toString());
            }
            catch (NumberFormatException e) {
                resolveable = this.internalDefaultResolveable();
            }
        }
        return resolveable;
    }

    private boolean internalDefaultResolveable() {
        boolean resolveable;
        try {
            resolveable = Boolean.valueOf((String)this.getConfiguredProperty("defaultResolveable"));
        }
        catch (NumberFormatException ex) {
            resolveable = true;
        }
        return resolveable;
    }

    @Override
    protected List<ManageableEntity> handleGetAllManageables() {
        TreeSet<ManageableEntity> allManageableEntities = new TreeSet<ManageableEntity>(new ManageableComparator());
        Collection allClasses = this.getModel().getAllClasses();
        for (Object classObject : allClasses) {
            if (!(classObject instanceof ManageableEntity)) continue;
            allManageableEntities.add((ManageableEntity)classObject);
        }
        return new ArrayList<ManageableEntity>(allManageableEntities);
    }

    static final class ManageableComparator
    implements Serializable,
    Comparator {
        private static final long serialVersionUID = 1L;

        ManageableComparator() {
        }

        public int compare(Object left, Object right) {
            ModelElementFacade leftEntity = (ModelElementFacade)left;
            ModelElementFacade rightEntity = (ModelElementFacade)right;
            return leftEntity.getName().compareTo(rightEntity.getName());
        }
    }

    private static enum ListType {
        PRIMITIVE,
        WRAPPER;

    }
}

