/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate.metafacades;

import org.andromda.cartridges.hibernate.metafacades.HibernateMetafacadeUtils;
import org.andromda.cartridges.hibernate.metafacades.HibernateServiceLogic;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class HibernateServiceLogicImpl
extends HibernateServiceLogic {
    private static final long serialVersionUID = 34L;
    private static final String VIEW_TYPE_REMOTE = "remote";

    public HibernateServiceLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetEjbJndiName() {
        StringBuilder jndiName = new StringBuilder();
        String jndiNamePrefix = StringUtils.trimToEmpty((String)this.getEjbJndiNamePrefix());
        if (StringUtils.isNotBlank((String)jndiNamePrefix)) {
            jndiName.append(jndiNamePrefix);
            jndiName.append('/');
        }
        jndiName.append("ejb/");
        jndiName.append(this.getFullyQualifiedName());
        return jndiName.toString();
    }

    @Override
    protected String handleGetEjbViewType() {
        String defaultViewType = String.valueOf(this.getConfiguredProperty("ejbViewType"));
        return HibernateMetafacadeUtils.getViewType((ClassifierFacade)this, defaultViewType);
    }

    protected String getEjbJndiNamePrefix() {
        String property = "ejbJndiNamePrefix";
        return this.isConfiguredProperty("ejbJndiNamePrefix") ? ObjectUtils.toString((Object)this.getConfiguredProperty("ejbJndiNamePrefix")) : null;
    }

    @Override
    protected boolean handleIsEjbStateful() {
        return !this.getAttributes().isEmpty();
    }

    @Override
    protected boolean handleIsEjbRemoteView() {
        return this.getEjbViewType().equalsIgnoreCase(VIEW_TYPE_REMOTE);
    }
}

