/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.WekaException;
import weka.gui.knowledgeflow.NoteVisual;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.Note;
import weka.knowledgeflow.steps.Step;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

public class StepVisual
extends JPanel {
    public static final String BASE_ICON_PATH = "weka/gui/knowledgeflow/icons/";
    private static final long serialVersionUID = 4156046438296843760L;
    protected int m_x;
    protected int m_y;
    protected ImageIcon m_icon;
    protected boolean m_displayConnectors;
    protected Color m_connectorColor = Color.blue;
    protected StepManagerImpl m_stepManager;

    private StepVisual(ImageIcon icon) {
        this.m_icon = icon;
        if (icon != null) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            JLabel visual = new JLabel(this.m_icon);
            this.add((Component)visual, "Center");
            Dimension d = visual.getPreferredSize();
            Dimension d2 = new Dimension((int)d.getWidth() + 10, (int)d.getHeight() + 10);
            this.setMinimumSize(d2);
            this.setPreferredSize(d2);
            this.setMaximumSize(d2);
        }
    }

    protected StepVisual() {
        this((ImageIcon)null);
    }

    public static StepVisual createVisual(StepManagerImpl stepManager) {
        if (stepManager.getManagedStep() instanceof Note) {
            NoteVisual wrapper = new NoteVisual();
            wrapper.setStepManager(stepManager);
            return wrapper;
        }
        ImageIcon icon = StepVisual.iconForStep(stepManager.getManagedStep());
        return StepVisual.createVisual(stepManager, icon);
    }

    public static StepVisual createVisual(StepManagerImpl stepManager, ImageIcon icon) {
        StepVisual wrapper = new StepVisual(icon);
        wrapper.setStepManager(stepManager);
        return wrapper;
    }

    public static ImageIcon iconForStep(Step step) {
        KFStep stepAnnotation = step.getClass().getAnnotation(KFStep.class);
        if (stepAnnotation != null && stepAnnotation.iconPath() != null && stepAnnotation.iconPath().length() > 0) {
            return StepVisual.loadIcon(step.getClass().getClassLoader(), stepAnnotation.iconPath());
        }
        if (step instanceof WekaAlgorithmWrapper) {
            ImageIcon icon = StepVisual.loadIcon(((WekaAlgorithmWrapper)step).getWrappedAlgorithm().getClass().getClassLoader(), ((WekaAlgorithmWrapper)step).getIconPath());
            if (icon == null) {
                icon = StepVisual.loadIcon(((WekaAlgorithmWrapper)step).getDefaultPackageLevelIconPath());
            }
            if (icon == null) {
                icon = StepVisual.loadIcon(((WekaAlgorithmWrapper)step).getDefaultIconPath());
            }
            return icon;
        }
        return null;
    }

    public static ImageIcon loadIcon(String iconPath) {
        return StepVisual.loadIcon(StepVisual.class.getClassLoader(), iconPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon loadIcon(ClassLoader classLoader, String iconPath) {
        InputStream imageStream = classLoader.getResourceAsStream(iconPath);
        if (imageStream != null) {
            try {
                BufferedImage pic = ImageIO.read(imageStream);
                ImageIcon imageIcon = new ImageIcon(pic);
                return imageIcon;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    imageStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static ImageIcon scaleIcon(ImageIcon icon, double factor) {
        Image pic = icon.getImage();
        double width = icon.getIconWidth();
        double height = icon.getIconHeight();
        pic = pic.getScaledInstance((int)(width *= factor), (int)(height *= factor), 4);
        return new ImageIcon(pic);
    }

    public Image getIcon(double scale) {
        if (scale == 1.0) {
            return this.m_icon.getImage();
        }
        Image pic = this.m_icon.getImage();
        double width = this.m_icon.getIconWidth();
        double height = this.m_icon.getIconHeight();
        pic = pic.getScaledInstance((int)(width *= scale), (int)(height *= scale), 4);
        return pic;
    }

    public String getStepName() {
        return this.m_stepManager.getManagedStep().getName();
    }

    public void setStepName(String name) {
        this.m_stepManager.getManagedStep().setName(name);
    }

    @Override
    public int getX() {
        return this.m_x;
    }

    public void setX(int x) {
        this.m_x = x;
    }

    @Override
    public int getY() {
        return this.m_y;
    }

    public void setY(int y) {
        this.m_y = y;
    }

    public StepManagerImpl getStepManager() {
        return this.m_stepManager;
    }

    public void setStepManager(StepManagerImpl manager) {
        this.m_stepManager = manager;
    }

    public String getCustomEditorForStep() {
        return this.m_stepManager.getManagedStep().getCustomEditorForStep();
    }

    public Set<String> getStepInteractiveViewActionNames() {
        Map<String, String> viewComps = this.m_stepManager.getManagedStep().getInteractiveViewers();
        if (viewComps == null) {
            return null;
        }
        return viewComps.keySet();
    }

    public JComponent getStepInteractiveViewComponent(String viewActionName) throws WekaException {
        if (this.m_stepManager.getManagedStep().getInteractiveViewers() == null) {
            throw new WekaException("Step '" + this.m_stepManager.getManagedStep().getName() + "' " + "does not have any interactive view components");
        }
        String clazz = this.m_stepManager.getManagedStep().getInteractiveViewers().get(viewActionName);
        if (clazz == null) {
            throw new WekaException("Step '" + this.m_stepManager.getManagedStep().getName() + "' " + "does not have an interactive view component called '" + viewActionName + "'");
        }
        Object comp = null;
        try {
            comp = Beans.instantiate(this.getClass().getClassLoader(), clazz);
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
        if (!(comp instanceof JComponent)) {
            throw new WekaException("Interactive view component '" + clazz + "' does not " + "extend JComponent");
        }
        return (JComponent)comp;
    }

    public Point getClosestConnectorPoint(Point pt) {
        int cx;
        int sourceX = this.getX();
        int sourceY = this.getY();
        int sourceWidth = this.getWidth();
        int sourceHeight = this.getHeight();
        int sourceMidX = sourceX + sourceWidth / 2;
        int sourceMidY = sourceY + sourceHeight / 2;
        int x = (int)pt.getX();
        int y = (int)pt.getY();
        Point closest = new Point();
        int n = Math.abs(x - sourceMidX) < Math.abs(y - sourceMidY) ? sourceMidX : (cx = x < sourceMidX ? sourceX : sourceX + sourceWidth);
        int cy = Math.abs(y - sourceMidY) < Math.abs(x - sourceMidX) ? sourceMidY : (y < sourceMidY ? sourceY : sourceY + sourceHeight);
        closest.setLocation(cx, cy);
        return closest;
    }

    public void setDisplayConnectors(boolean dc) {
        this.m_displayConnectors = dc;
        this.m_connectorColor = Color.blue;
        this.repaint();
    }

    public void setDisplayConnectors(boolean dc, Color c) {
        this.setDisplayConnectors(dc);
        this.m_connectorColor = c;
    }

    public boolean getDisplayStepLabel() {
        return true;
    }

    @Override
    public void paintComponent(Graphics gx) {
        ((Graphics2D)gx).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(gx);
        if (this.m_displayConnectors) {
            gx.setColor(this.m_connectorColor);
            int midx = (int)((double)this.getWidth() / 2.0);
            int midy = (int)((double)this.getHeight() / 2.0);
            gx.fillOval(midx - 2, 0, 5, 5);
            gx.fillOval(midx - 2, this.getHeight() - 5, 5, 5);
            gx.fillOval(0, midy - 2, 5, 5);
            gx.fillOval(this.getWidth() - 5, midy - 2, 5, 5);
        }
    }
}

