/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.plugins.jira.service;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.plugins.jira.model.IssueComment;
import net.thucydides.plugins.jira.model.IssueTracker;
import net.thucydides.plugins.jira.model.IssueTrackerUpdateException;
import net.thucydides.plugins.jira.service.JIRAConfiguration;
import net.thucydides.plugins.jira.service.JIRAConnection;
import net.thucydides.plugins.jira.service.NoSuchIssueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import thucydides.plugins.jira.soap.RemoteComment;
import thucydides.plugins.jira.soap.RemoteIssue;
import thucydides.plugins.jira.soap.RemoteNamedObject;
import thucydides.plugins.jira.soap.RemoteStatus;

public class JiraIssueTracker
implements IssueTracker {
    private final Logger logger;
    private final JIRAConnection jiraConnection;
    private final Marker warn = MarkerFactory.getMarker((String)"WARN");
    private Map<String, String> statusCodeMap = null;
    private Map<String, String> statusLabelMap = null;

    @Inject
    public JiraIssueTracker(JIRAConfiguration jiraConfiguration) {
        this(LoggerFactory.getLogger(JiraIssueTracker.class), jiraConfiguration);
    }

    public JiraIssueTracker(Logger logger, JIRAConfiguration jiraConfiguration) {
        this.logger = logger;
        this.jiraConnection = new JIRAConnection(jiraConfiguration);
    }

    public String toString() {
        return "Connection to JIRA instance at " + this.jiraConnection.getJiraWebserviceUrl() + " with user " + this.jiraConnection.getJiraUser();
    }

    @Override
    public void addComment(String issueKey, String commentText) throws IssueTrackerUpdateException {
        try {
            String token = this.jiraConnection.getAuthenticationToken();
            RemoteComment comment = this.newCommentWithText(commentText);
            this.jiraConnection.getJiraSoapService().addComment(token, issueKey, comment);
        }
        catch (IOException exception) {
            this.processJiraException(issueKey, exception);
        }
    }

    private void processJiraException(String issueKey, IOException exception) {
        if (!this.noSuchIssue(exception)) {
            throw new IssueTrackerUpdateException("Could not update JIRA using URL (" + this.jiraConnection.getJiraWebserviceUrl() + ")", exception);
        }
        this.logger.error("No JIRA issue found with key {}", (Object)issueKey);
    }

    private boolean noSuchIssue(Exception exception) {
        return exception.toString().contains("This issue does not exist");
    }

    @Override
    public List<IssueComment> getCommentsFor(String issueKey) throws IssueTrackerUpdateException {
        List results = Collections.emptyList();
        try {
            String token = this.jiraConnection.getAuthenticationToken();
            RemoteComment[] comments = this.jiraConnection.getJiraSoapService().getComments(token, issueKey);
            results = Lambda.convert((Object)comments, (Converter)new CommentConverter());
        }
        catch (IOException e) {
            this.processJiraException(issueKey, e);
        }
        return results;
    }

    @Override
    public void updateComment(IssueComment issueComment) {
        try {
            String token = this.jiraConnection.getAuthenticationToken();
            RemoteComment updatedComment = this.jiraConnection.getJiraSoapService().getComment(token, issueComment.getId());
            updatedComment.setBody(issueComment.getText());
            this.jiraConnection.getJiraSoapService().editComment(token, updatedComment);
        }
        catch (IOException e) {
            throw new IssueTrackerUpdateException("Could not update JIRA using URL (" + this.jiraConnection.getJiraWebserviceUrl() + ")", e);
        }
    }

    @Override
    public String getStatusFor(String issueKey) throws IssueTrackerUpdateException {
        String status = null;
        try {
            String token = this.jiraConnection.getAuthenticationToken();
            RemoteIssue issue = this.jiraConnection.getJiraSoapService().getIssue(token, issueKey);
            this.checkThatIssueExists(issue, issueKey);
            status = this.getStatusLabel(issue);
        }
        catch (IOException e) {
            this.processJiraException(issueKey, e);
        }
        return status;
    }

    @Override
    public void doTransition(String issueKey, String workflowAction) throws IssueTrackerUpdateException {
        try {
            String token = this.jiraConnection.getAuthenticationToken();
            RemoteIssue issue = this.jiraConnection.getJiraSoapService().getIssue(token, issueKey);
            this.checkThatIssueExists(issue, issueKey);
            String actionId = this.getAvailableActions(issueKey).get(workflowAction);
            if (actionId != null) {
                this.jiraConnection.getJiraSoapService().progressWorkflowAction(token, issueKey, actionId, null);
            }
        }
        catch (IOException e) {
            this.processJiraException(issueKey, e);
        }
    }

    private String getStatusLabel(RemoteIssue issue) {
        return this.getStatusCodeMap().get(issue.getStatus());
    }

    private Map<String, String> getAvailableActions(String issueKey) {
        HashMap<String, String> availableActionMap = null;
        if (availableActionMap == null) {
            availableActionMap = new HashMap<String, String>();
            try {
                RemoteNamedObject[] actions;
                String token = this.jiraConnection.getAuthenticationToken();
                RemoteNamedObject[] remoteNamedObjectArray = actions = this.jiraConnection.getJiraSoapService().getAvailableActions(token, issueKey);
                int n = actions.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteNamedObject action = remoteNamedObjectArray[n2];
                    availableActionMap.put(action.getName(), action.getId());
                    ++n2;
                }
            }
            catch (IOException e) {
                this.processJiraException(issueKey, e);
            }
        }
        return availableActionMap;
    }

    private Map<String, String> getStatusCodeMap() {
        if (this.statusCodeMap == null) {
            this.statusCodeMap = new HashMap<String, String>();
            try {
                RemoteStatus[] statuses;
                String token = this.jiraConnection.getAuthenticationToken();
                RemoteStatus[] remoteStatusArray = statuses = this.jiraConnection.getJiraSoapService().getStatuses(token);
                int n = statuses.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteStatus status = remoteStatusArray[n2];
                    this.statusCodeMap.put(status.getId(), status.getName());
                    ++n2;
                }
            }
            catch (IOException e) {
                throw new IssueTrackerUpdateException("Could not read JIRA using URL (" + this.jiraConnection.getJiraWebserviceUrl() + ")", e);
            }
        }
        return this.statusCodeMap;
    }

    private String getStatusId(String statusLabel) {
        return this.getStatusLabelMap().get(statusLabel);
    }

    private Map<String, String> getStatusLabelMap() {
        if (this.statusLabelMap == null) {
            this.statusLabelMap = new HashMap<String, String>();
            try {
                RemoteStatus[] statuses;
                String token = this.jiraConnection.getAuthenticationToken();
                RemoteStatus[] remoteStatusArray = statuses = this.jiraConnection.getJiraSoapService().getStatuses(token);
                int n = statuses.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteStatus status = remoteStatusArray[n2];
                    this.statusLabelMap.put(status.getName(), status.getId());
                    ++n2;
                }
            }
            catch (IOException e) {
                throw new IssueTrackerUpdateException("Could not read JIRA using URL (" + this.jiraConnection.getJiraWebserviceUrl() + ")", e);
            }
        }
        return this.statusLabelMap;
    }

    private void checkThatIssueExists(RemoteIssue issue, String issueKey) {
        if (issue == null) {
            this.logger.error(this.warn, "JIRA issue not found for {}", (Object)issueKey);
            throw new NoSuchIssueException("No issue found for " + issueKey);
        }
    }

    private RemoteComment newCommentWithText(String commentText) {
        RemoteComment comment = new RemoteComment();
        comment.setAuthor(this.jiraConnection.getJiraUser());
        comment.setBody(commentText);
        return comment;
    }

    private class CommentConverter
    implements Converter<RemoteComment, IssueComment> {
        private CommentConverter() {
        }

        public IssueComment convert(RemoteComment from) {
            return new IssueComment(Long.valueOf(from.getId()), from.getBody(), from.getAuthor());
        }
    }
}

