/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.plugins.jira.domain;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.plugins.jira.domain.CustomFieldCast;
import net.thucydides.plugins.jira.domain.RenderedView;

public class IssueSummary {
    private final URI self;
    private final Long id;
    private final String key;
    private final String summary;
    private final String description;
    private final String type;
    private final List<String> labels;
    private final List<String> fixVersions;
    private final Map<String, Object> customFieldValues;
    private final Map<String, String> renderedFieldValues;

    public IssueSummary(URI self, Long id, String key, String summary, String description, Map<String, String> renderedFieldValues, String type) {
        this(self, id, key, summary, description, renderedFieldValues, type, new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, Object>());
    }

    public IssueSummary(URI self, Long id, String key, String summary, String description, Map<String, String> renderedFieldValues, String type, List<String> labels, List<String> fixVersions, Map<String, Object> customFields) {
        this.self = self;
        this.id = id;
        this.key = key;
        this.summary = summary;
        this.description = description;
        this.renderedFieldValues = renderedFieldValues;
        this.type = type;
        this.labels = ImmutableList.copyOf(labels);
        this.fixVersions = ImmutableList.copyOf(fixVersions);
        this.customFieldValues = ImmutableMap.copyOf(customFields);
    }

    public URI getSelf() {
        return this.self;
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<String> getFixVersions() {
        return this.fixVersions;
    }

    public String toString() {
        return "IssueSummary{key='" + this.key + '\'' + ", summary='" + this.summary + '\'' + '}';
    }

    public Optional<CustomFieldCast> customField(String fieldName) {
        if (this.customFieldValues.get(fieldName) == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new CustomFieldCast(this.customFieldValues.get(fieldName)));
    }

    public RenderedView getRendered() {
        return new RenderedView(this.renderedFieldValues);
    }
}

