/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.plugins.jira.client;

import com.beust.jcommander.internal.Maps;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.thucydides.plugins.jira.client.FindByJQLLoader;
import net.thucydides.plugins.jira.client.FindByKeyLoader;
import net.thucydides.plugins.jira.client.JIRAAuthenticationError;
import net.thucydides.plugins.jira.client.JIRAConfigurationError;
import net.thucydides.plugins.jira.client.Redirector;
import net.thucydides.plugins.jira.domain.IssueSummary;
import net.thucydides.plugins.jira.domain.Version;
import net.thucydides.plugins.jira.model.CascadingSelectOption;
import net.thucydides.plugins.jira.model.CustomField;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyJiraClient {
    private static final String REST_SEARCH = "rest/api/latest/search";
    private static final String VERSIONS_SEARCH = "rest/api/latest/project/%s/versions";
    private static final int REDIRECT_REQUEST = 302;
    private static final String DEFAULT_ISSUE_TYPE = "Bug";
    private final String url;
    private final String username;
    private final String password;
    private final int batchSize;
    private final String project;
    private final List<String> customFields;
    private Map<String, CustomField> customFieldsIndex;
    private Map<String, String> customFieldNameIndex;
    private String metadataIssueType;
    private LoadingCache<String, Optional<IssueSummary>> issueSummaryCache;
    private LoadingCache<String, List<IssueSummary>> issueQueryCache;
    private final Logger logger = LoggerFactory.getLogger(JerseyJiraClient.class);
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final int OK = 200;

    public JerseyJiraClient(String url, String username, String password, String project) {
        this(url, username, password, 100, project);
    }

    public JerseyJiraClient(String url, String username, String password, String project, List<String> customFields) {
        this(url, username, password, 100, project, DEFAULT_ISSUE_TYPE, customFields);
    }

    public JerseyJiraClient(String url, String username, String password, int batchSize, String project, String metadataIssueType, List<String> customFields) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.batchSize = batchSize;
        this.project = project;
        this.metadataIssueType = metadataIssueType;
        this.customFields = ImmutableList.copyOf(customFields);
        this.issueSummaryCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new FindByKeyLoader(this));
        this.issueQueryCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new FindByJQLLoader(this));
    }

    public JerseyJiraClient(String url, String username, String password, int batchSize, String project) {
        this(url, username, password, batchSize, project, DEFAULT_ISSUE_TYPE, Collections.EMPTY_LIST);
    }

    public JerseyJiraClient usingCustomFields(List<String> customFields) {
        return new JerseyJiraClient(this.url, this.username, this.password, this.batchSize, this.project, this.metadataIssueType, customFields);
    }

    public JerseyJiraClient usingMetadataIssueType(String metadataIssueType) {
        return new JerseyJiraClient(this.url, this.username, this.password, this.batchSize, this.project, metadataIssueType, this.customFields);
    }

    public List<IssueSummary> findByJQL(String query) throws JSONException {
        try {
            Preconditions.checkNotNull((Object)query, (Object)"JIRA key cannot be null");
            return (List)this.issueQueryCache.get((Object)query);
        }
        catch (ExecutionException e) {
            throw new JSONException(e.getCause());
        }
        catch (RuntimeException runtimeException) {
            throw new JSONException(runtimeException.getCause());
        }
    }

    protected List<IssueSummary> loadByJQL(String query) throws JSONException {
        int total = this.countByJQL(query);
        ArrayList issues = Lists.newArrayList();
        int startAt = 0;
        while (issues.size() < total) {
            String jsonResponse = this.getJSONResponse(query, startAt);
            JSONObject responseObject = new JSONObject(jsonResponse);
            JSONArray issueEntries = (JSONArray)responseObject.get("issues");
            int i = 0;
            while (i < issueEntries.length()) {
                JSONObject issueObject = issueEntries.getJSONObject(i);
                issues.add(this.convertToIssueSummary(issueObject));
                ++i;
            }
            startAt += this.getBatchSize();
        }
        return issues;
    }

    public List<Version> findVersionsForProject(String projectName) throws JSONException {
        String versionData = this.getJSONProjectVersions(projectName);
        return this.convertJSONVersions(versionData);
    }

    private List<Version> convertJSONVersions(String versionData) throws JSONException {
        ArrayList versions = Lists.newArrayList();
        JSONArray versionEntries = new JSONArray(versionData);
        int i = 0;
        while (i < versionEntries.length()) {
            JSONObject issueObject = versionEntries.getJSONObject(i);
            versions.add(this.convertToVersion(issueObject));
            ++i;
        }
        return versions;
    }

    public WebTarget buildWebTargetFor(String path) {
        return this.restClient().target(this.url).path(path);
    }

    private String getJSONResponse(String query, int startAt) throws JSONException {
        String fields = "key,summary,description,issuetype,labels,fixVersions";
        fields = this.addCustomFieldsTo(fields);
        WebTarget target = this.buildWebTargetFor(REST_SEARCH).queryParam("jql", new Object[]{query}).queryParam("startAt", new Object[]{startAt}).queryParam("maxResults", new Object[]{this.batchSize}).queryParam("expand", new Object[]{"renderedFields"}).queryParam("fields", new Object[]{fields});
        Response response = target.request().get();
        this.checkValid(response);
        return (String)response.readEntity(String.class);
    }

    private String addCustomFieldsTo(String fields) throws JSONException {
        for (String customField : this.customFields) {
            if (!this.getCustomFieldsIndex().containsKey(customField)) continue;
            fields = String.valueOf(fields) + "," + this.getCustomFieldsIndex().get(customField).getId();
        }
        return fields;
    }

    private String getJSONProjectVersions(String projectName) throws JSONException {
        String url = String.format(VERSIONS_SEARCH, projectName);
        WebTarget target = this.buildWebTargetFor(url);
        Response response = target.request().get();
        this.checkValid(response);
        return (String)response.readEntity(String.class);
    }

    public Optional<IssueSummary> findByKey(String key) throws JSONException {
        try {
            Preconditions.checkNotNull((Object)key, (Object)"JIRA key cannot be null");
            return (Optional)this.issueSummaryCache.get((Object)key);
        }
        catch (ExecutionException e) {
            throw new JSONException(e.getCause());
        }
        catch (RuntimeException runtimeException) {
            throw new JSONException(runtimeException.getCause());
        }
    }

    public Optional<IssueSummary> loadByKey(String key) throws JSONException {
        Optional<String> jsonResponse = this.readFieldValues(this.url, "rest/api/2/issue/" + key);
        if (jsonResponse.isPresent()) {
            JSONObject responseObject = new JSONObject((String)jsonResponse.get());
            return Optional.of((Object)this.convertToIssueSummary(responseObject));
        }
        return Optional.absent();
    }

    private Version convertToVersion(JSONObject issueObject) throws JSONException {
        try {
            return new Version(this.uriFrom(issueObject), issueObject.getLong("id"), this.stringValueOf(issueObject.get("name")), this.booleanValueOf(issueObject.get("archived")), this.booleanValueOf(issueObject.get("released")));
        }
        catch (JSONException e) {
            this.logger.error("Could not load issue from JSON", (Throwable)e);
            this.logger.error("JSON:" + issueObject.toString(4));
            throw e;
        }
    }

    private IssueSummary convertToIssueSummary(JSONObject issueObject) throws JSONException {
        JSONObject fields = (JSONObject)issueObject.get("fields");
        JSONObject renderedFields = (JSONObject)issueObject.get("renderedFields");
        JSONObject issueType = (JSONObject)fields.get("issuetype");
        try {
            Map<String, String> renderedFieldValues = this.renderedFieldValuesFrom(renderedFields);
            return new IssueSummary(this.uriFrom(issueObject), issueObject.getLong("id"), this.stringValueOf(issueObject.get("key")), this.stringValueOf(fields.get("summary")), this.stringValueOf(this.optional(fields, "description")), renderedFieldValues, this.stringValueOf(issueType.get("name")), this.toList((JSONArray)fields.get("labels")), this.toListOfVersions((JSONArray)fields.get("fixVersions")), this.customFieldValuesIn(fields, renderedFields));
        }
        catch (JSONException e) {
            this.logger.error("Could not load issue from JSON", (Throwable)e);
            this.logger.error("JSON:" + issueObject.toString(4));
            throw e;
        }
    }

    private Map<String, String> renderedFieldValuesFrom(JSONObject renderedFields) throws JSONException {
        Map renderedFieldMap = Maps.newHashMap();
        for (Object key : Lists.newArrayList((Iterator)renderedFields.sortedKeys())) {
            String fieldName = (String)key;
            String renderedValue = renderedFields.getString(fieldName);
            if (this.getCustomFieldNameIndex().containsKey(fieldName)) {
                fieldName = this.getCustomFieldNameIndex().get(key);
            }
            renderedFieldMap.put(fieldName, renderedValue);
        }
        return renderedFieldMap;
    }

    private Map<String, Object> customFieldValuesIn(JSONObject fields, JSONObject renderedFields) throws JSONException {
        Map customFieldValues = Maps.newHashMap();
        for (String customFieldName : this.customFields) {
            CustomField customField = this.getCustomFieldsIndex().get(customFieldName);
            if (!this.customFieldDefined(fields, renderedFields, customField)) continue;
            Object customFieldValue = this.readFieldValue(fields, customField);
            customFieldValues.put(customFieldName, customFieldValue);
        }
        return customFieldValues;
    }

    private boolean customFieldDefined(JSONObject fields, JSONObject renderedFields, CustomField customField) throws JSONException {
        if (customField != null) {
            return this.hasCustomFieldValue(fields, customField) || this.hasCustomFieldValue(renderedFields, customField);
        }
        return false;
    }

    private boolean hasCustomFieldValue(JSONObject fields, CustomField customField) throws JSONException {
        return fields.has(customField.getId()) && !fields.get(customField.getId()).equals(null);
    }

    private Object readFieldValue(JSONObject fields, CustomField customField) throws JSONException {
        String fieldValue;
        String fieldId = customField.getId();
        String string = fieldValue = this.fieldIsDefined(fields, fieldId) ? fields.getString(fieldId) : "";
        if (this.isJSON(fieldValue)) {
            JSONObject field = new JSONObject(fieldValue);
            if (customField.getType().equals("string")) {
                return field == JSONObject.NULL ? "" : field.getString("value");
            }
            if (customField.getType().equals("array")) {
                return this.readListFrom(field);
            }
        }
        return fieldValue;
    }

    private boolean fieldIsDefined(JSONObject fields, String fieldId) throws JSONException {
        return fields.has(fieldId) && fields.get(fieldId) != JSONObject.NULL;
    }

    private boolean isJSON(String fieldValue) {
        return fieldValue.trim().startsWith("{");
    }

    private List<String> readListFrom(JSONObject jsonField) throws JSONException {
        ArrayList values = Lists.newArrayList();
        values.add(jsonField.getString("value"));
        if (jsonField.has("child")) {
            values.addAll(this.readListFrom(jsonField.getJSONObject("child")));
        }
        return values;
    }

    private List<CustomField> convertToCustomFields(JSONArray customFieldsList) throws JSONException {
        ArrayList customFields = Lists.newArrayList();
        int i = 0;
        while (i < customFieldsList.length()) {
            JSONObject fieldObject = customFieldsList.getJSONObject(i);
            customFields.add(this.convertToCustomField(fieldObject));
            ++i;
        }
        return customFields;
    }

    private CustomField convertToCustomField(JSONObject fieldObject) throws JSONException {
        return new CustomField(fieldObject.getString("id"), fieldObject.getString("name"), this.fieldTypeOf(fieldObject));
    }

    private String fieldTypeOf(JSONObject fieldObject) throws JSONException {
        if (fieldObject.has("schema")) {
            return fieldObject.getJSONObject("schema").getString("type");
        }
        return "string";
    }

    private Object optional(JSONObject fields, String fieldName) throws JSONException {
        return fields.has(fieldName) ? fields.get(fieldName) : null;
    }

    private List<String> toList(JSONArray array) throws JSONException {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while (i < array.length()) {
            list.add(this.stringValueOf(array.get(i)));
            ++i;
        }
        return list;
    }

    private List<String> toListOfVersions(JSONArray array) throws JSONException {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while (i < array.length()) {
            JSONObject versionObject = (JSONObject)array.get(i);
            list.add(versionObject.getString("name"));
            ++i;
        }
        return list;
    }

    private URI uriFrom(JSONObject issueObject) throws JSONException {
        try {
            return new URI((String)issueObject.get("self"));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Self field not a valid URL");
        }
    }

    public Integer countByJQL(String query) throws JSONException {
        return this.loadCountByJQL(query);
    }

    protected Integer loadCountByJQL(String query) throws JSONException {
        int total;
        WebTarget target = this.buildWebTargetFor(REST_SEARCH).queryParam("jql", new Object[]{query});
        Response response = target.request().get();
        if (this.isEmpty(response)) {
            return 0;
        }
        this.checkValid(response);
        String jsonResponse = (String)response.readEntity(String.class);
        try {
            JSONObject responseObject = new JSONObject(jsonResponse);
            total = (Integer)responseObject.get("total");
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Invalid JQL query: " + query);
        }
        return total;
    }

    private Optional<String> readFieldValues(String url, String path) throws JSONException {
        WebTarget target = this.restClient().target(url).path(path).queryParam("expand", new Object[]{"renderedFields"});
        Response response = target.request().get();
        if (response.getStatus() == 302) {
            response = Redirector.forPath(path).usingClient(this.restClient()).followRedirectsIn(response);
        }
        if (this.resourceDoesNotExist(response)) {
            return Optional.absent();
        }
        this.checkValid(response);
        return Optional.of((Object)((String)response.readEntity(String.class)));
    }

    private Optional<String> readFieldMetadata(String url, String path) throws JSONException {
        WebTarget target = this.restClient().target(url).path(path).queryParam("expand", new Object[]{"renderedFields"}).queryParam("project", new Object[]{this.project}).queryParam("issuetypeName", new Object[]{this.metadataIssueType}).queryParam("expand", new Object[]{"projects.issuetypes.fields"});
        Response response = target.request().get();
        if (response.getStatus() == 302) {
            response = Redirector.forPath(path).usingClient(this.restClient()).followRedirectsIn(response);
        }
        if (this.resourceDoesNotExist(response)) {
            return Optional.absent();
        }
        this.checkValid(response);
        return Optional.of((Object)((String)response.readEntity(String.class)));
    }

    public Client restClient() {
        return ((ClientBuilder)ClientBuilder.newBuilder().register((Object)new HttpBasicAuthFilter(this.username, this.password))).build();
    }

    private String stringValueOf(Object field) {
        if (field != null) {
            return field.toString();
        }
        return null;
    }

    private boolean booleanValueOf(Object field) {
        if (field != null) {
            return Boolean.valueOf(field.toString());
        }
        return false;
    }

    public boolean resourceDoesNotExist(Response response) {
        return response.getStatus() == 404;
    }

    public boolean isEmpty(Response response) {
        return response.getStatus() == 400;
    }

    public void checkValid(Response response) throws JSONException {
        int status = response.getStatus();
        if (status != 200) {
            switch (status) {
                case 401: {
                    this.handleAuthenticationError("Authentication error (401) for user " + this.username);
                }
                case 403: {
                    this.handleAuthenticationError("Forbidden error (403) for user " + this.username);
                }
                case 404: {
                    this.handleConfigurationError("Service not found (404) - try checking the JIRA URL?");
                }
                case 407: {
                    this.handleConfigurationError("Proxy authentication required (407)");
                }
            }
            throw new JSONException("JIRA query failed: error " + status);
        }
    }

    private void handleAuthenticationError(String message) {
        throw new JIRAAuthenticationError(message);
    }

    private void handleConfigurationError(String message) {
        throw new JIRAConfigurationError(message);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    private Map<String, CustomField> getCustomFieldsIndex() throws JSONException {
        if (this.customFieldsIndex == null) {
            this.customFieldsIndex = this.indexCustomFields();
        }
        return this.customFieldsIndex;
    }

    private Map<String, String> getCustomFieldNameIndex() throws JSONException {
        if (this.customFieldNameIndex == null) {
            this.customFieldNameIndex = this.indexCustomFieldNames();
        }
        return this.customFieldNameIndex;
    }

    private Map<String, String> indexCustomFieldNames() throws JSONException {
        Map index = Maps.newHashMap();
        for (CustomField field : this.getExistingCustomFields()) {
            index.put(field.getId(), field.getName());
        }
        return index;
    }

    private Map<String, CustomField> indexCustomFields() throws JSONException {
        Map index = Maps.newHashMap();
        for (CustomField field : this.getExistingCustomFields()) {
            index.put(field.getName(), field);
        }
        return index;
    }

    private List<CustomField> getExistingCustomFields() throws JSONException {
        Optional<String> jsonResponse = this.readFieldValues(this.url, "rest/api/2/field");
        if (jsonResponse.isPresent()) {
            JSONArray responseObject = new JSONArray((String)jsonResponse.get());
            return this.convertToCustomFields(responseObject);
        }
        return Collections.EMPTY_LIST;
    }

    List<CustomField> getCustomFields() throws JSONException {
        ArrayList registeredCustomFields = Lists.newArrayList();
        for (String fieldName : this.customFields) {
            registeredCustomFields.add(this.getCustomFieldsIndex().get(fieldName));
        }
        return registeredCustomFields;
    }

    public List<CascadingSelectOption> findOptionsForCascadingSelect(String fieldName) {
        JSONObject responseObject = null;
        try {
            Optional<String> jsonResponse = this.readFieldMetadata(this.url, "rest/api/2/issue/createmeta");
            if (jsonResponse.isPresent()) {
                responseObject = new JSONObject((String)jsonResponse.get());
                JSONObject fields = responseObject.getJSONArray("projects").getJSONObject(0).getJSONArray("issuetypes").getJSONObject(0).getJSONObject("fields");
                Iterator fieldKeys = fields.keys();
                while (fieldKeys.hasNext()) {
                    String entryFieldName = (String)fieldKeys.next();
                    JSONObject entry = fields.getJSONObject(entryFieldName);
                    if (!entry.getString("name").equalsIgnoreCase(fieldName)) continue;
                    return this.convertToCascadingSelectOptions(entry.getJSONArray("allowedValues"));
                }
            }
        }
        catch (JSONException e) {
            this.logger.error("Could not read cascading select options", (Throwable)e);
            this.logger.info("responseObject = " + responseObject);
        }
        return Collections.EMPTY_LIST;
    }

    private List<CascadingSelectOption> convertToCascadingSelectOptions(JSONArray allowedValues) throws JSONException {
        return this.convertToCascadingSelectOptions(allowedValues, null);
    }

    private List<CascadingSelectOption> convertToCascadingSelectOptions(JSONArray allowedValues, CascadingSelectOption parentOption) throws JSONException {
        ArrayList options = Lists.newArrayList();
        int i = 0;
        while (i < allowedValues.length()) {
            JSONObject entry = (JSONObject)allowedValues.get(i);
            String value = entry.getString("value");
            CascadingSelectOption option = new CascadingSelectOption(value, parentOption);
            List<Object> children = Lists.newArrayList();
            if (entry.has("children")) {
                children = this.convertToCascadingSelectOptions(entry.getJSONArray("children"), option);
            }
            option.addChildren(children);
            options.add(option);
            ++i;
        }
        return options;
    }
}

