/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.html.HtmlAggregateStoryReporter;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class ThucydidesAggregatorMojo
extends AbstractMojo {
    public File outputDirectory;
    public File sourceDirectory;
    public String issueTrackerUrl;
    public String jiraUrl;
    public String jiraUsername;
    public String jiraPassword;
    public String jiraProject;
    public String requirementsBaseDir;
    public String statisticsDriver;
    public String statisticsUsername;
    public String statisticsPassword;
    public String statisticsDialect;
    public String statisticsUrl;
    EnvironmentVariables environmentVariables;
    public String projectKey;
    private HtmlAggregateStoryReporter reporter;

    protected void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    protected void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void prepareExecution() {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        this.configureEnvironmentVariables();
    }

    private EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        }
        return this.environmentVariables;
    }

    private void configureEnvironmentVariables() {
        Locale.setDefault(Locale.ENGLISH);
        this.updateSystemProperty(ThucydidesSystemProperty.PROJECT_KEY.getPropertyName(), this.projectKey, Thucydides.getDefaultProjectKey());
        this.updateSystemProperty("thucydides.statistics.driver_class", this.statisticsDriver);
        this.updateSystemProperty("thucydides.statistics.url", this.statisticsUrl);
        this.updateSystemProperty("thucydides.statistics.username", this.statisticsUsername);
        this.updateSystemProperty("thucydides.statistics.password", this.statisticsPassword);
        this.updateSystemProperty("thucydides.statistics.dialect", this.statisticsDialect);
        this.updateSystemProperty("thucydides.test.requirements.basedir", this.requirementsBaseDir);
    }

    private void updateSystemProperty(String key, String value, String defaultValue) {
        if (value != null) {
            this.getEnvironmentVariables().setProperty(key, value);
        } else {
            this.getEnvironmentVariables().setProperty(key, defaultValue);
        }
    }

    private void updateSystemProperty(String key, String value) {
        if (value != null) {
            this.getEnvironmentVariables().setProperty(key, value);
        }
    }

    protected void setReporter(HtmlAggregateStoryReporter reporter) {
        this.reporter = reporter;
    }

    public void execute() throws MojoExecutionException {
        this.prepareExecution();
        try {
            this.generateHtmlStoryReports();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating aggregate thucydides reports", (Exception)e);
        }
    }

    protected HtmlAggregateStoryReporter getReporter() {
        if (this.reporter == null) {
            this.reporter = new HtmlAggregateStoryReporter(this.projectKey);
        }
        return this.reporter;
    }

    private void generateHtmlStoryReports() throws IOException {
        this.getReporter().setSourceDirectory(this.sourceOfTestResult());
        this.getReporter().setOutputDirectory(this.outputDirectory);
        this.getReporter().setIssueTrackerUrl(this.issueTrackerUrl);
        this.getReporter().setJiraUrl(this.jiraUrl);
        this.getReporter().setJiraProject(this.jiraProject);
        this.getReporter().setJiraUsername(this.jiraUsername);
        this.getReporter().setJiraPassword(this.jiraPassword);
        this.getReporter().generateReportsForTestResultsFrom(this.sourceOfTestResult());
    }

    private File sourceOfTestResult() {
        if (this.sourceDirectory != null && this.sourceDirectory.exists()) {
            return this.sourceDirectory;
        }
        return this.outputDirectory;
    }
}

