/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs;

import javax.ws.rs.core.Response;

public enum ResponseStatus implements Response.StatusType
{
    MULTI_STATUS(207, "Multi-Status"),
    UNPROCESSABLE_ENTITY(422, "Unprocessable Entity"),
    LOCKED(423, "Locked"),
    FAILED_DEPENDENCY(424, "Failed Dependency"),
    INSUFFICIENT_STORAGE(507, "Insufficient Storage");

    private final int statusCode;
    private final String reasonPhrase;

    private ResponseStatus(int statusCode, String reasonPhrase) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final Response.Status.Family getFamily() {
        switch (this.statusCode / 100) {
            case 1: {
                return Response.Status.Family.INFORMATIONAL;
            }
            case 2: {
                return Response.Status.Family.SUCCESSFUL;
            }
            case 3: {
                return Response.Status.Family.REDIRECTION;
            }
            case 4: {
                return Response.Status.Family.CLIENT_ERROR;
            }
        }
        return Response.Status.Family.SERVER_ERROR;
    }

    @Deprecated
    public final String toString() {
        return this.reasonPhrase;
    }

    public final String getReasonPhrase() {
        return this.reasonPhrase;
    }
}

