/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.upload.factorys.disk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.hasor.utils.io.IOUtils;
import net.hasor.web.FileItemStream;
import net.hasor.web.upload.FileItemBase;
import net.hasor.web.upload.util.DeferredFileOutputStream;

public class DiskFileItem
extends FileItemBase {
    public static final int DEFAULT_SIZE_THRESHOLD = 51200;
    private DeferredFileOutputStream dfos;
    private File cacheFile;

    public DiskFileItem(FileItemStream stream, File cacheFile) throws IOException {
        super(stream);
        this.init(stream, cacheFile);
    }

    protected void init(FileItemStream stream, File cacheFile) throws IOException {
        this.cacheFile = cacheFile;
        File parent = cacheFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        this.dfos = new DeferredFileOutputStream(51200, cacheFile);
        IOUtils.copy((InputStream)stream.openStream(), (OutputStream)this.dfos);
    }

    protected void finalize() throws Throwable {
        try {
            this.deleteOrSkip();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public long getSize() {
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    @Override
    public void deleteOrSkip() {
        try {
            if (this.cacheFile != null && this.cacheFile.exists()) {
                this.cacheFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public InputStream openStream() throws IOException {
        if (this.dfos.isInMemory()) {
            return new ByteArrayInputStream(this.dfos.getData());
        }
        return new FileInputStream(this.dfos.getFile());
    }
}

