/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.upload;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;

class ServletRequestContext {
    private final HttpServletRequest request;

    public ServletRequestContext(HttpServletRequest request) {
        this.request = request;
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public long contentLength() {
        long size;
        try {
            size = Long.parseLong(this.request.getHeader("Content-length"));
        }
        catch (NumberFormatException e) {
            size = this.request.getContentLength();
        }
        return size;
    }

    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String toString() {
        return String.format("ContentLength=%s, ContentType=%s", this.contentLength(), this.getContentType());
    }
}

