/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.startup;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.hasor.core.AppContext;
import net.hasor.core.Hasor;
import net.hasor.core.Module;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.core.spi.SpiTrigger;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeListener
implements ServletContextListener,
HttpSessionListener,
ServletRequestListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String AppContextName = AppContext.class.getName();
    private boolean contextIsOutsite = false;
    private Supplier<AppContext> appContext = null;
    private SpiTrigger spiTrigger = null;

    public RuntimeListener() {
        this.contextIsOutsite = false;
    }

    public RuntimeListener(AppContext appContext) {
        this(InstanceProvider.of((Object)Objects.requireNonNull(appContext, "appContext is null.")));
    }

    public RuntimeListener(Supplier<AppContext> appContext) {
        this.appContext = Objects.requireNonNull(appContext, "appContext is null.");
        this.contextIsOutsite = true;
    }

    public static AppContext getAppContext(ServletContext servletContext) {
        return (AppContext)servletContext.getAttribute(AppContextName);
    }

    protected Hasor newHasor(ServletContext sc, String configName, Properties properties) throws Throwable {
        Hasor webHasor = Hasor.create((Object)sc);
        if (StringUtils.isNotBlank((String)configName)) {
            webHasor.mainSettingWith(configName);
        }
        if (properties != null && !properties.isEmpty()) {
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> webHasor.addVariable(key.toString(), val.toString())));
        }
        return webHasor;
    }

    protected Module newRootModule(ServletContext sc, String rootModule) throws Exception {
        if (StringUtils.isBlank((String)rootModule)) {
            this.logger.info("web initModule is undefinition.");
            return null;
        }
        Class<?> startModuleClass = Thread.currentThread().getContextClassLoader().loadClass(rootModule);
        this.logger.info("web initModule is " + rootModule);
        return (Module)startModuleClass.newInstance();
    }

    protected Properties loadEnvProperties(ServletContext sc, String envPropertieName) throws IOException {
        if (StringUtils.isBlank((String)envPropertieName)) {
            this.logger.info("properties file is undefinition.");
            return null;
        }
        InputStream resourceAsStream = ResourcesUtils.getResourceAsStream((String)envPropertieName);
        if (resourceAsStream == null) {
            this.logger.error("properties file is " + envPropertieName + " , but there is not exist.");
            return null;
        }
        this.logger.info("properties file is " + envPropertieName);
        Properties prop = new Properties();
        prop.load(new InputStreamReader(resourceAsStream, "UTF-8"));
        return prop;
    }

    protected AppContext doInit(ServletContext sc) {
        try {
            String rootModule = sc.getInitParameter("hasor-root-module");
            String configName = sc.getInitParameter("hasor-hconfig-name");
            String envProperties = sc.getInitParameter("hasor-envconfig-name");
            Properties properties = this.loadEnvProperties(sc, envProperties);
            Module startModule = this.newRootModule(sc, rootModule);
            Hasor newHasor = this.newHasor(sc, configName, properties);
            String webContextDir = sc.getRealPath("/");
            newHasor.addVariable("HASOR_WEBROOT", webContextDir);
            return newHasor.build(new Module[]{startModule});
        }
        catch (Throwable e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    public final void contextInitialized(ServletContextEvent servletContextEvent) {
        if (this.appContext == null) {
            this.appContext = InstanceProvider.of((Object)this.doInit(servletContextEvent.getServletContext()));
        }
        this.spiTrigger = (SpiTrigger)this.appContext.get().getInstance(SpiTrigger.class);
        this.logger.info("ServletContext Attribut is " + AppContextName);
        servletContextEvent.getServletContext().setAttribute(AppContextName, (Object)this.appContext.get());
        this.spiTrigger.callSpi(ServletContextListener.class, listener -> listener.contextInitialized(servletContextEvent));
    }

    public final void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.spiTrigger.callSpi(ServletContextListener.class, listener -> listener.contextDestroyed(servletContextEvent));
        if (!this.contextIsOutsite) {
            this.appContext.get().shutdown();
            this.logger.info("shutdown.");
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
        this.spiTrigger.callSpi(HttpSessionListener.class, listener -> listener.sessionCreated(se));
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.spiTrigger.callSpi(HttpSessionListener.class, listener -> listener.sessionDestroyed(se));
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        this.spiTrigger.callSpi(ServletRequestListener.class, listener -> listener.requestDestroyed(sre));
    }

    public void requestInitialized(ServletRequestEvent sre) {
        this.spiTrigger.callSpi(ServletRequestListener.class, listener -> listener.requestInitialized(sre));
    }
}

