/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.render;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.render.RenderInvoker;
import net.hasor.web.wrap.InvokerWrap;

public class RenderInvokerSupplier
extends InvokerWrap
implements RenderInvoker {
    private String viewName = null;
    private String renderType = null;
    private boolean useLayout = true;

    protected RenderInvokerSupplier(Invoker invoker) {
        super(invoker);
        HttpServletRequest httpRequest = this.getHttpRequest();
        Enumeration paramEnum = httpRequest.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            Object paramKey = paramEnum.nextElement();
            String key = paramKey.toString();
            String val = httpRequest.getParameter(key);
            httpRequest.setAttribute("req_" + key, (Object)val);
        }
    }

    @Override
    public String renderTo() {
        return this.viewName;
    }

    @Override
    public void renderTo(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public void renderTo(String renderType, String viewName) {
        this.renderType(renderType);
        this.viewName = viewName;
    }

    @Override
    public String renderType() {
        return this.renderType;
    }

    @Override
    public void renderType(String renderType) {
        if (StringUtils.isBlank((String)renderType)) {
            throw new IllegalStateException("renderType is null.");
        }
        this.renderType = renderType.trim().toUpperCase();
    }

    @Override
    public boolean layout() {
        return this.useLayout;
    }

    @Override
    public void layoutEnable() {
        this.useLayout = true;
    }

    @Override
    public void layoutDisable() {
        this.useLayout = false;
    }
}

