/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.objects;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.FilenameUtils;
import net.hasor.utils.io.IOUtils;
import net.hasor.utils.resource.ResourceLoader;
import net.hasor.web.Invoker;
import net.hasor.web.InvokerChain;
import net.hasor.web.InvokerFilter;

public class ResourceFilter
implements InvokerFilter {
    private ResourceLoader loader;

    public ResourceFilter(ResourceLoader loader) {
        this.loader = loader;
    }

    @Override
    public Object doInvoke(Invoker invoker, InvokerChain chain) throws Throwable {
        long size;
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        String requestURI = httpRequest.getRequestURI();
        if (!this.loader.exist(requestURI)) {
            return chain.doNext(invoker);
        }
        HttpServletResponse httpResponse = invoker.getHttpResponse();
        String extension = FilenameUtils.getExtension((String)requestURI);
        String mimeType = invoker.getMimeType(extension);
        if (StringUtils.isNotBlank((String)mimeType)) {
            httpResponse.setContentType(mimeType);
        }
        if ((size = this.loader.getResourceSize(requestURI)) > 0L) {
            if (size >= Integer.MAX_VALUE) {
                httpResponse.setContentLengthLong(size);
            } else {
                httpResponse.setContentLength((int)size);
            }
        }
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();
             InputStream inputStream = this.loader.getResourceAsStream(requestURI);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        return null;
    }
}

