/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web.objects;

import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.servlet.http.HttpServletResponse;
import net.hasor.utils.StringUtils;
import net.hasor.web.render.RenderEngine;
import net.hasor.web.render.RenderInvoker;
import net.hasor.web.render.RenderType;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@RenderType(engineType=RedirectRenderEngine.class)
public @interface RedirectTo {

    public static class RedirectRenderEngine
    implements RenderEngine {
        @Override
        public void process(RenderInvoker invoker, Writer writer) throws Throwable {
            Object o = invoker.get("resultData");
            String redirectTo = null;
            if (o != null) {
                redirectTo = o.toString();
            }
            if (StringUtils.isBlank(redirectTo)) {
                throw new NullPointerException("redirect to empty.");
            }
            HttpServletResponse httpResponse = invoker.getHttpResponse();
            if (!httpResponse.isCommitted()) {
                httpResponse.sendRedirect(redirectTo);
            }
        }
    }
}

