/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import net.hasor.core.ApiBinder;
import net.hasor.core.BindInfo;
import net.hasor.core.TypeSupplier;
import net.hasor.core.aop.AsmTools;
import net.hasor.core.exts.aop.Matchers;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.utils.ArrayUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.web.InvokerFilter;
import net.hasor.web.MimeType;
import net.hasor.web.ServletVersion;
import net.hasor.web.annotation.MappingTo;
import net.hasor.web.render.Render;
import net.hasor.web.render.RenderEngine;

public interface WebApiBinder
extends ApiBinder,
MimeType {
    public ServletContext getServletContext();

    public WebApiBinder setRequestCharacter(String var1);

    public WebApiBinder setResponseCharacter(String var1);

    default public WebApiBinder setEncodingCharacter(String requestEncoding, String responseEncoding) {
        return this.setRequestCharacter(requestEncoding).setResponseCharacter(responseEncoding);
    }

    public ServletVersion getServletVersion();

    default public ServletBindingBuilder jeeServlet(String urlPattern, String ... morePatterns) {
        return this.jeeServlet((String[])ArrayUtils.add((Object[])morePatterns, (Object)urlPattern));
    }

    public ServletBindingBuilder jeeServlet(String[] var1);

    default public <T> MappingToBindingBuilder<T> mappingTo(String urlPattern, String ... morePatterns) {
        return this.mappingTo((String[])ArrayUtils.add((Object[])morePatterns, (Object)urlPattern));
    }

    public <T> MappingToBindingBuilder<T> mappingTo(String[] var1);

    default public WebApiBinder loadMappingTo(Set<Class<?>> udfTypeSet) {
        return this.loadMappingTo(udfTypeSet, Matchers.anyClass(), null);
    }

    default public WebApiBinder loadMappingTo(Set<Class<?>> mabeUdfTypeSet, Predicate<Class<?>> matcher, TypeSupplier typeSupplier) {
        if (mabeUdfTypeSet != null && !mabeUdfTypeSet.isEmpty()) {
            mabeUdfTypeSet.stream().filter(matcher).filter(Matchers.annotatedWithClass(MappingTo.class)).forEach(aClass -> this.loadMappingTo((Class<?>)aClass, typeSupplier));
        }
        return this;
    }

    default public WebApiBinder loadMappingTo(Class<?> mappingType) {
        return this.loadMappingTo(mappingType, null);
    }

    default public WebApiBinder loadMappingTo(Class<?> mappingType, TypeSupplier typeSupplier) {
        Objects.requireNonNull(mappingType, "class is null.");
        int modifier = mappingType.getModifiers();
        if (AsmTools.checkOr((int)modifier, (int[])new int[]{512, 1024}) || mappingType.isArray() || mappingType.isEnum()) {
            throw new IllegalStateException(mappingType.getName() + " must be normal Bean");
        }
        MappingTo[] annotationsByType = (MappingTo[])mappingType.getAnnotationsByType(MappingTo.class);
        if (annotationsByType == null || annotationsByType.length == 0) {
            throw new IllegalStateException(mappingType.getName() + " must be configure @MappingTo");
        }
        if (HttpServlet.class.isAssignableFrom(mappingType)) {
            Class<?> httpServletType = mappingType;
            Arrays.stream(annotationsByType).peek(mappingTo -> {}).forEach(mappingTo -> {
                if (!this.isSingleton(mappingType)) {
                    throw new IllegalStateException("HttpServlet " + mappingType + " must be Singleton.");
                }
                if (typeSupplier != null) {
                    this.jeeServlet(mappingTo.value()).with(() -> (HttpServlet)typeSupplier.get(httpServletType));
                } else {
                    this.jeeServlet(mappingTo.value()).with(httpServletType);
                }
            });
        } else {
            Class<?> mappingObjType = mappingType;
            Arrays.stream(annotationsByType).peek(mappingTo -> {}).forEach(mappingTo -> {
                if (typeSupplier != null) {
                    this.mappingTo(mappingTo.value()).with(mappingObjType, () -> typeSupplier.get(mappingObjType));
                } else {
                    this.mappingTo(mappingTo.value()).with(mappingType);
                }
            });
        }
        return this;
    }

    default public FilterBindingBuilder<InvokerFilter> filter(String urlPattern, String ... morePatterns) {
        return this.filter((String[])ArrayUtils.add((Object[])morePatterns, (Object)urlPattern));
    }

    public FilterBindingBuilder<InvokerFilter> filter(String[] var1);

    default public FilterBindingBuilder<InvokerFilter> filterRegex(String regex, String ... regexes) {
        return this.filter((String[])ArrayUtils.add((Object[])regexes, (Object)regex));
    }

    public FilterBindingBuilder<InvokerFilter> filterRegex(String[] var1);

    default public FilterBindingBuilder<Filter> jeeFilter(String urlPattern, String ... morePatterns) {
        return this.jeeFilter((String[])ArrayUtils.add((Object[])morePatterns, (Object)urlPattern));
    }

    public FilterBindingBuilder<Filter> jeeFilter(String[] var1);

    default public FilterBindingBuilder<Filter> jeeFilterRegex(String regex, String ... regexes) {
        return this.jeeFilterRegex((String[])ArrayUtils.add((Object[])regexes, (Object)regex));
    }

    public FilterBindingBuilder<Filter> jeeFilterRegex(String[] var1);

    default public <T extends EventListener> void bindSpiListener(Class<T> spiType, T listener) {
        this.bindSpiListener(spiType, () -> listener);
    }

    public <T extends EventListener> void bindSpiListener(Class<T> var1, Supplier<T> var2);

    public void addMimeType(String var1, String var2);

    default public void loadMimeType(String resource) throws IOException {
        this.loadMimeType(StandardCharsets.UTF_8, resource);
    }

    default public void loadMimeType(InputStream inputStream) throws IOException {
        this.loadMimeType(StandardCharsets.UTF_8, inputStream);
    }

    default public void loadMimeType(Charset charset, String resource) throws IOException {
        this.loadMimeType(charset, Objects.requireNonNull(ResourcesUtils.getResourceAsStream((String)resource), resource + " is not exist"));
    }

    default public void loadMimeType(Charset charset, InputStream inputStream) throws IOException {
        this.loadMimeType(new InputStreamReader(inputStream, charset));
    }

    public void loadMimeType(Reader var1) throws IOException;

    default public WebApiBinder loadRender(Set<Class<?>> udfTypeSet) {
        return this.loadRender(udfTypeSet, Matchers.anyClass(), null);
    }

    default public WebApiBinder loadRender(Set<Class<?>> mabeUdfTypeSet, Predicate<Class<?>> matcher, TypeSupplier typeSupplier) {
        if (mabeUdfTypeSet != null && !mabeUdfTypeSet.isEmpty()) {
            mabeUdfTypeSet.stream().filter(matcher).filter(Matchers.annotatedWithClass(Render.class)).forEach(aClass -> this.loadRender((Class<?>)aClass, typeSupplier));
        }
        return this;
    }

    default public WebApiBinder loadRender(Class<?> renderClass) {
        return this.loadRender(renderClass, null);
    }

    default public WebApiBinder loadRender(Class<?> renderClass, TypeSupplier typeSupplier) {
        Objects.requireNonNull(renderClass, "class is null.");
        int modifier = renderClass.getModifiers();
        if (AsmTools.checkOr((int)modifier, (int[])new int[]{512, 1024}) || renderClass.isArray() || renderClass.isEnum()) {
            throw new IllegalStateException(renderClass.getName() + " must be normal Bean");
        }
        if (!renderClass.isAnnotationPresent(Render.class)) {
            throw new IllegalStateException(renderClass.getName() + " must be configure @Render");
        }
        if (!RenderEngine.class.isAssignableFrom(renderClass)) {
            throw new IllegalStateException(renderClass.getName() + " must be implements RenderEngine.");
        }
        Class<?> engineClass = renderClass;
        Render renderInfo = renderClass.getAnnotation(Render.class);
        if (renderInfo != null && renderInfo.value().length > 0) {
            for (String renderName : renderInfo.value()) {
                if (typeSupplier == null) {
                    this.addRender(renderName).to(engineClass);
                    continue;
                }
                this.addRender(renderName).toProvider(() -> (RenderEngine)typeSupplier.get(engineClass));
            }
        }
        return this;
    }

    public RenderEngineBindingBuilder addRender(String var1);

    public static interface RenderEngineBindingBuilder {
        public <T extends RenderEngine> void to(Class<T> var1);

        default public void toInstance(RenderEngine renderEngine) {
            this.toProvider((Supplier<? extends RenderEngine>)new InstanceProvider((Object)renderEngine));
        }

        public void toProvider(Supplier<? extends RenderEngine> var1);

        public void bindToInfo(BindInfo<? extends RenderEngine> var1);
    }

    public static interface MappingToBindingBuilder<T> {
        default public void with(Class<? extends T> targetKey) {
            this.with(0, (T)targetKey);
        }

        default public void with(T target) {
            this.with(0, target);
        }

        default public void with(Class<T> referKey, Supplier<? extends T> targetProvider) {
            this.with(0, referKey, targetProvider);
        }

        default public void with(BindInfo<? extends T> targetInfo) {
            this.with(0, targetInfo);
        }

        public void with(int var1, Class<? extends T> var2);

        public void with(int var1, T var2);

        public void with(int var1, Class<T> var2, Supplier<? extends T> var3);

        public void with(int var1, BindInfo<? extends T> var2);
    }

    public static interface ServletBindingBuilder {
        default public void with(Class<? extends HttpServlet> targetKey) {
            this.with(0, targetKey, null);
        }

        default public void with(HttpServlet target) {
            this.with(0, target, null);
        }

        default public void with(Supplier<? extends HttpServlet> targetProvider) {
            this.with(0, targetProvider, null);
        }

        default public void with(BindInfo<? extends HttpServlet> targetInfo) {
            this.with(0, targetInfo, null);
        }

        default public void with(Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(0, servletKey, initParams);
        }

        default public void with(HttpServlet servlet, Map<String, String> initParams) {
            this.with(0, servlet, initParams);
        }

        default public void with(Supplier<? extends HttpServlet> servletProvider, Map<String, String> initParams) {
            this.with(0, servletProvider, initParams);
        }

        default public void with(BindInfo<? extends HttpServlet> servletRegister, Map<String, String> initParams) {
            this.with(0, servletRegister, initParams);
        }

        default public void with(int index, Class<? extends HttpServlet> targetKey) {
            this.with(index, targetKey, null);
        }

        default public void with(int index, HttpServlet target) {
            this.with(index, target, null);
        }

        default public void with(int index, Supplier<? extends HttpServlet> targetProvider) {
            this.with(index, targetProvider, null);
        }

        default public void with(int index, BindInfo<? extends HttpServlet> targetInfo) {
            this.with(index, targetInfo, null);
        }

        public void with(int var1, Class<? extends HttpServlet> var2, Map<String, String> var3);

        public void with(int var1, HttpServlet var2, Map<String, String> var3);

        public void with(int var1, Supplier<? extends HttpServlet> var2, Map<String, String> var3);

        public void with(int var1, BindInfo<? extends HttpServlet> var2, Map<String, String> var3);
    }

    public static interface FilterBindingBuilder<T> {
        default public void through(Class<? extends T> filterKey) {
            this.through(0, (T)filterKey, null);
        }

        default public void through(T filter) {
            this.through(0, filter, null);
        }

        default public void through(Supplier<? extends T> filterProvider) {
            this.through(0, filterProvider, (Map<String, String>)null);
        }

        default public void through(BindInfo<? extends T> filterRegister) {
            this.through(0, filterRegister, (Map<String, String>)null);
        }

        default public void through(Class<? extends T> filterKey, Map<String, String> initParams) {
            this.through(0, (T)filterKey, initParams);
        }

        default public void through(T filter, Map<String, String> initParams) {
            this.through(0, filter, initParams);
        }

        default public void through(Supplier<? extends T> filterProvider, Map<String, String> initParams) {
            this.through(0, filterProvider, initParams);
        }

        default public void through(BindInfo<? extends T> filterRegister, Map<String, String> initParams) {
            this.through(0, filterRegister, initParams);
        }

        default public void through(int index, Class<? extends T> filterKey) {
            this.through(index, (T)filterKey, null);
        }

        default public void through(int index, T filter) {
            this.through(index, filter, null);
        }

        default public void through(int index, Supplier<? extends T> filterProvider) {
            this.through(index, filterProvider, (Map<String, String>)null);
        }

        default public void through(int index, BindInfo<? extends T> filterRegister) {
            this.through(index, filterRegister, (Map<String, String>)null);
        }

        public void through(int var1, Class<? extends T> var2, Map<String, String> var3);

        public void through(int var1, T var2, Map<String, String> var3);

        public void through(int var1, Supplier<? extends T> var2, Map<String, String> var3);

        public void through(int var1, BindInfo<? extends T> var2, Map<String, String> var3);
    }
}

