/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSource;
import net.coobird.thumbnailator.util.exif.ExifFilterUtils;
import net.coobird.thumbnailator.util.exif.ExifUtils;
import net.coobird.thumbnailator.util.exif.Orientation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamImageSource
extends AbstractImageSource<InputStream> {
    private static final int FIRST_IMAGE_INDEX = 0;
    private final InputStream is;

    public InputStreamImageSource(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("InputStream cannot be null.");
        }
        this.is = inputStream;
    }

    @Override
    public BufferedImage read() throws IOException {
        Object object;
        Object object2;
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(this.is);
        if (imageInputStream == null) {
            throw new IOException("Could not open InputStream.");
        }
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            throw new UnsupportedFormatException("<unknown>", "No suitable ImageReader found for source data.");
        }
        ImageReader imageReader = iterator.next();
        imageReader.setInput(imageInputStream);
        this.inputFormatName = imageReader.getFormatName();
        try {
            if (this.param.useExifOrientation() && (object2 = ExifUtils.getExifOrientation(imageReader, 0)) != null && object2 != Orientation.TOP_LEFT) {
                object = this.param.getImageFilters();
                object.add(0, ExifFilterUtils.getFilterForOrientation(object2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.param != null && this.param.getSourceRegion() != null) {
            object = this.param.getSourceRegion();
            int n = imageReader.getWidth(0);
            int n2 = imageReader.getHeight(0);
            Rectangle rectangle = ((Region)object).calculate(n, n2);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            imageReadParam.setSourceRegion(rectangle);
            object2 = imageReader.read(0, imageReadParam);
        } else {
            object2 = imageReader.read(0);
        }
        imageReader.dispose();
        imageInputStream.close();
        return (BufferedImage)((Object)this.finishedReading(object2));
    }

    @Override
    public InputStream getSource() {
        return this.is;
    }
}

