/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.validation.utils;

import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import nc.ird.cantharella.utils.AssertTools;
import org.hibernate.EntityMode;
import org.hibernate.event.spi.AbstractPreDatabaseOperationEvent;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelValidatorEventListener
implements PreInsertEventListener,
PreUpdateEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ModelValidatorEventListener.class);
    private final Validator validator;

    public ModelValidatorEventListener(ValidatorFactory factory) {
        AssertTools.assertNotNull((Object)factory);
        this.validator = factory.getValidator();
    }

    public boolean onPreInsert(PreInsertEvent event) {
        this.validate((AbstractPreDatabaseOperationEvent)event, Operation.INSERT);
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        this.validate((AbstractPreDatabaseOperationEvent)event, Operation.UPDATE);
        return false;
    }

    private void validate(AbstractPreDatabaseOperationEvent event, Operation operation) {
        Set violations;
        Object o = event.getEntity();
        if (event.getEntity() != null && event.getPersister().getEntityMode() == EntityMode.POJO && !(violations = this.validator.validate(o, new Class[0])).isEmpty()) {
            LOG.error("Validation before " + operation.name() + " " + o.getClass().getName() + ":");
            for (ConstraintViolation violation : violations) {
                LOG.error("- " + violation.getPropertyPath() + ": " + violation.getMessage());
            }
            throw new ConstraintViolationException("Validation failed before " + operation.name() + " " + o.getClass().getName(), new HashSet(violations));
        }
    }

    private static enum Operation {
        INSERT,
        UPDATE;

    }
}

