/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Molecule;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.IndexedEmbedded;

@Entity
public class MoleculeProvenance
extends AbstractModel
implements Cloneable {
    @Id
    @GeneratedValue
    private Integer id;
    @Min(value=0L)
    @Max(value=100L)
    @Column(precision=9, scale=4)
    private BigDecimal pourcentage;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @ContainedIn
    private Molecule molecule;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded
    private Produit produit;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public BigDecimal getPourcentage() {
        return this.pourcentage;
    }

    public void setPourcentage(BigDecimal pourcentage) {
        this.pourcentage = pourcentage;
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    public void setMolecule(Molecule molecule) {
        this.molecule = molecule;
    }

    public Produit getProduit() {
        return this.produit;
    }

    public void setProduit(Produit produit) {
        this.produit = produit;
    }

    public MoleculeProvenance clone() throws CloneNotSupportedException {
        MoleculeProvenance clone = (MoleculeProvenance)super.clone();
        clone.id = this.id;
        clone.pourcentage = this.pourcentage;
        clone.molecule = this.molecule;
        clone.produit = this.produit;
        return clone;
    }
}

