/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.validation.CollectionUniqueField;
import org.hibernate.search.annotations.IndexedEmbedded;

@Entity
@CollectionUniqueField(fieldName="ref", pathToCollection="extraction.extraits")
@Embeddable
public class Extrait
extends Produit {
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private TypeExtrait typeExtrait;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded
    private Extraction extraction;

    public Float getRendement() {
        Float rendement;
        if (this.getExtraction() != null && this.getExtraction().getMasseDepart() != null && this.getExtraction().getMasseDepart().floatValue() != 0.0f && this.getMasseObtenue() != null && (rendement = Float.valueOf(this.getMasseObtenue().floatValue() / this.getExtraction().getMasseDepart().floatValue())).floatValue() <= 1.0f && rendement.floatValue() >= 0.0f) {
            return rendement;
        }
        return null;
    }

    @Override
    public boolean isExtrait() {
        return true;
    }

    @Override
    public boolean isFraction() {
        return false;
    }

    @Override
    public Extrait clone() throws CloneNotSupportedException {
        Extrait clone = (Extrait)super.clone();
        clone.typeExtrait = this.typeExtrait;
        clone.extraction = this.extraction;
        return clone;
    }

    public TypeExtrait getTypeExtrait() {
        return this.typeExtrait;
    }

    public void setTypeExtrait(TypeExtrait typeExtrait) {
        this.typeExtrait = typeExtrait;
    }

    public Extraction getExtraction() {
        return this.extraction;
    }

    public void setExtraction(Extraction extraction) {
        this.extraction = extraction;
    }
}

