/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.CampagneGroupeDroits;
import nc.ird.cantharella.data.model.CampagnePersonneDroits;
import nc.ird.cantharella.data.model.CampagnePersonneParticipant;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import nc.ird.cantharella.data.validation.CountryCode;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table
@Embeddable
public class Campagne
extends AbstractModel
implements Comparable<Campagne>,
DocumentAttachable {
    @Id
    @GeneratedValue
    private Integer idCampagne;
    @Column(unique=true)
    @NotNull
    @NotEmpty
    @Length(max=60)
    @Field(store=Store.YES)
    private String nom;
    @NotNull
    @CountryCode
    @Length(min=2, max=2)
    private String codePays;
    @Length(max=60)
    private String programme;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String mentionLegale;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String complement;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date dateDeb;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date dateFin;
    @NotNull
    @OneToMany(mappedBy="id.pk1", fetch=FetchType.LAZY)
    private List<CampagneGroupeDroits> groupesDroits;
    @NotNull
    @OneToMany(mappedBy="campagne", fetch=FetchType.LAZY)
    @ContainedIn
    private List<Lot> lots = new ArrayList<Lot>();
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @NotNull
    @OneToMany(mappedBy="id.pk1", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private List<CampagnePersonneParticipant> participants = new ArrayList<CampagnePersonneParticipant>();
    @NotNull
    @OneToMany(mappedBy="id.pk1", fetch=FetchType.LAZY)
    private List<CampagnePersonneDroits> personnesDroits;
    @NotNull
    @ManyToMany(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @ContainedIn
    private List<Station> stations = new ArrayList<Station>();
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="campagne")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Fetch(value=FetchMode.SUBSELECT)
    private List<Document> documents;

    public Campagne() {
        this.personnesDroits = new ArrayList<CampagnePersonneDroits>();
        this.groupesDroits = new ArrayList<CampagneGroupeDroits>();
        this.documents = new ArrayList<Document>();
    }

    public String toString() {
        return this.nom;
    }

    @Override
    public int compareTo(Campagne campagne) {
        return new BeanComparator("nom").compare((Object)this, (Object)campagne);
    }

    public List<Station> getSortedStations() {
        Collections.sort(this.stations);
        return this.stations;
    }

    public Integer getIdCampagne() {
        return this.idCampagne;
    }

    public void setIdCampagne(Integer idCampagne) {
        this.idCampagne = idCampagne;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getCodePays() {
        return this.codePays;
    }

    public void setCodePays(String codePays) {
        this.codePays = codePays;
    }

    public String getProgramme() {
        return this.programme;
    }

    public void setProgramme(String programme) {
        this.programme = programme;
    }

    public String getMentionLegale() {
        return this.mentionLegale;
    }

    public void setMentionLegale(String mentionLegale) {
        this.mentionLegale = mentionLegale;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String complement) {
        this.complement = complement;
    }

    public Date getDateDeb() {
        return this.dateDeb;
    }

    public void setDateDeb(Date dateDeb) {
        this.dateDeb = dateDeb;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public List<CampagneGroupeDroits> getGroupesDroits() {
        return this.groupesDroits;
    }

    public void setGroupesDroits(List<CampagneGroupeDroits> groupesDroits) {
        this.groupesDroits = groupesDroits;
    }

    public List<Lot> getLots() {
        return this.lots;
    }

    public void setLots(List<Lot> lots) {
        this.lots = lots;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne createur) {
        this.createur = createur;
    }

    public List<CampagnePersonneParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<CampagnePersonneParticipant> participants) {
        this.participants = participants;
    }

    public List<CampagnePersonneDroits> getPersonnesDroits() {
        return this.personnesDroits;
    }

    public void setPersonnesDroits(List<CampagnePersonneDroits> personnesDroits) {
        this.personnesDroits = personnesDroits;
    }

    public List<Station> getStations() {
        return this.stations;
    }

    public void setStations(List<Station> stations) {
        this.stations = stations;
    }

    @Override
    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public void addDocument(Document document) {
        this.documents.add(document);
    }

    @Override
    public void removeDocument(Document document) {
        this.documents.remove(document);
    }
}

