/*
 * Decompiled with CFR 0.152.
 */
package lt.velykis.maven.skins.reflow;

import lt.velykis.maven.skins.reflow.HtmlTool;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@DefaultKey(value="config")
public class SkinConfigTool
extends SafeConfig {
    public static final String DEFAULT_KEY = "config";
    public static final String SKIN_KEY = "reflowSkin";
    private String key = "config";
    private String skinKey = "reflowSkin";
    private Xpp3Dom globalProperties = new Xpp3Dom("");
    private Xpp3Dom pageProperties = new Xpp3Dom("");
    private String namespace = "";
    private String projectId = null;
    private String fileId = null;

    protected void configure(ValueParser values) {
        Object decorationObj;
        Object currentFileObj;
        Object velocityContext;
        String altSkinKey;
        String altkey = values.getString("key");
        if (altkey != null) {
            this.setKey(altkey);
        }
        if ((altSkinKey = values.getString("skinKey")) != null) {
            this.skinKey = altSkinKey;
        }
        if (!((velocityContext = values.get("velocityContext")) instanceof ToolContext)) {
            return;
        }
        ToolContext ctxt = (ToolContext)velocityContext;
        Object projectObj = ctxt.get("project");
        if (projectObj instanceof MavenProject) {
            MavenProject project = (MavenProject)projectObj;
            String artifactId = project.getArtifactId();
            this.projectId = HtmlTool.slug(artifactId);
        }
        if ((currentFileObj = ctxt.get("currentFileName")) instanceof String) {
            String currentFile = (String)currentFileObj;
            int lastDot = currentFile.lastIndexOf(".");
            if (lastDot >= 0) {
                currentFile = currentFile.substring(0, lastDot);
            }
            this.fileId = HtmlTool.slug(currentFile.replace("/", "-").replace("\\", "-"));
        }
        if (!((decorationObj = ctxt.get("decoration")) instanceof DecorationModel)) {
            return;
        }
        DecorationModel decoration = (DecorationModel)decorationObj;
        Object customObj = decoration.getCustom();
        if (!(customObj instanceof Xpp3Dom)) {
            return;
        }
        Xpp3Dom customNode = (Xpp3Dom)customObj;
        Xpp3Dom skinNode = customNode.getChild(this.skinKey);
        String namespaceKey = ":" + this.skinKey;
        if (skinNode == null) {
            for (Xpp3Dom child : customNode.getChildren()) {
                if (!child.getName().endsWith(namespaceKey)) continue;
                skinNode = child;
                break;
            }
        }
        if (skinNode != null) {
            Xpp3Dom pagesNode;
            this.globalProperties = skinNode;
            if (skinNode.getName().endsWith(namespaceKey)) {
                this.namespace = skinNode.getName().substring(0, skinNode.getName().length() - namespaceKey.length() + 1);
            }
            if ((pagesNode = this.getChild(skinNode, "pages")) != null) {
                String pageProject;
                Xpp3Dom page = this.getChild(pagesNode, this.fileId);
                if (page != null && this.projectId != null && (pageProject = page.getAttribute("project")) != null && !this.projectId.equals(pageProject)) {
                    page = null;
                }
                if (page != null) {
                    this.pageProperties = page;
                }
            }
        }
    }

    private Xpp3Dom getChild(Xpp3Dom parentNode, String name) {
        Xpp3Dom child = parentNode.getChild(name);
        if (child != null) {
            return child;
        }
        return parentNode.getChild(this.namespace + name);
    }

    protected void setKey(String key) {
        if (key == null) {
            throw new NullPointerException("SkinConfigTool key cannot be null");
        }
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public Xpp3Dom get(String property) {
        Xpp3Dom propNode = this.getChild(this.pageProperties, property);
        if (propNode == null) {
            propNode = this.getChild(this.globalProperties, property);
        }
        return propNode;
    }

    public String value(String property) {
        Xpp3Dom propNode = this.get(property);
        if (propNode == null) {
            return null;
        }
        return propNode.getValue();
    }

    public boolean is(String property) {
        return "true".equals(this.value(property));
    }

    public boolean not(String property) {
        return "false".equals(this.value(property));
    }

    public boolean isValue(String property, String value) {
        return value != null && value.equals(this.value(property));
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getFileId() {
        return this.fileId;
    }
}

