/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.internal.Throwables;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.processor.ProcessorContext;

class TracingValueTransformer<V, VR>
implements ValueTransformer<V, VR> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final Tracer tracer;
    final String spanName;
    final ValueTransformer<V, VR> delegateTransformer;
    ProcessorContext processorContext;

    TracingValueTransformer(KafkaStreamsTracing kafkaStreamsTracing, String spanName, ValueTransformer<V, VR> delegateTransformer) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracer;
        this.spanName = spanName;
        this.delegateTransformer = delegateTransformer;
    }

    public void init(ProcessorContext processorContext) {
        this.processorContext = processorContext;
        this.delegateTransformer.init(processorContext);
    }

    public VR transform(V v) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.processorContext);
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        Throwable error = null;
        try {
            Object object = this.delegateTransformer.transform(v);
            return (VR)object;
        }
        catch (Throwable e) {
            error = e;
            Throwables.propagateIfFatal((Throwable)e);
            throw e;
        }
        finally {
            this.kafkaStreamsTracing.injector.inject(span.context(), (Object)this.processorContext.headers());
            if (error != null) {
                span.error(error);
            }
            span.finish();
            ws.close();
        }
    }

    public void close() {
        this.delegateTransformer.close();
    }
}

