/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.StatusCode;

class SMTPQuit {
    private static final Logger log = LoggerFactory.getLogger(SMTPQuit.class);
    private final SMTPConnection connection;
    private final Handler<Void> resultHandler;

    SMTPQuit(SMTPConnection connection, Handler<Void> resultHandler) {
        this.connection = connection;
        this.resultHandler = resultHandler;
    }

    void start() {
        this.connection.setErrorHandler((Handler<Throwable>)((Handler)th -> {
            log.debug((Object)"QUIT failed, ignoring exception", th);
            this.resultHandler.handle(null);
        }));
        this.connection.write("QUIT", (Handler<String>)((Handler)message -> {
            log.debug((Object)("QUIT result: " + message));
            if (!StatusCode.isStatusOk(message)) {
                log.warn((Object)("quit failed: " + message));
            }
            this.resultHandler.handle(null);
        }));
    }
}

