/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.bean;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.bean.JavaBeanPredicate;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public interface JavaBeanStream<O extends JavaBean, P extends JavaBeanStream<O, P>>
extends JavaBeanPredicate<O, P> {
    public void addComparator(Comparator<O> var1);

    public Optional<Comparator<O>> comparator();

    public Stream<O> stream();

    default public Stream<O> filter() {
        return this.sortedStream().filter(this);
    }

    default public boolean anyMatch() {
        return this.stream().anyMatch(this);
    }

    default public boolean allMatch() {
        return this.stream().allMatch(this);
    }

    default public boolean noneMatch() {
        return this.stream().noneMatch(this);
    }

    default public Stream<O> sortedStream() {
        Optional<Comparator<O>> comparator = this.comparator();
        return comparator.isPresent() ? this.stream().sorted(comparator.get()) : this.stream();
    }

    default public Optional<O> min() {
        Optional<Comparator<O>> comparator = this.comparator();
        return comparator.isPresent() ? this.stream().min(comparator.get()) : Optional.empty();
    }

    default public Optional<O> max() {
        Optional<Comparator<O>> comparator = this.comparator();
        return comparator.isPresent() ? this.stream().max(comparator.get()) : Optional.empty();
    }

    public static class StreamStringQuery<O extends JavaBean, P extends JavaBeanStream<O, P>, Q extends StreamStringQuery<O, P, Q>>
    extends JavaBeanPredicate.StringQuery<O, P, Q>
    implements StreamComparableQuery<O, String, P, Q> {
        public StreamStringQuery(P parent, Function<O, String> getter) {
            super(parent, getter);
        }
    }

    public static class StreamSimpleComparableQuery<O extends JavaBean, V extends Comparable<V>, P extends JavaBeanStream<O, P>, Q extends StreamSimpleComparableQuery<O, V, P, Q>>
    extends JavaBeanPredicate.SimpleComparableQuery<O, V, P, Q>
    implements StreamComparableQuery<O, V, P, Q> {
        public StreamSimpleComparableQuery(P parent, Function<O, V> getter) {
            super(parent, getter);
        }
    }

    public static class StreamObjectBooleanQuery<O extends JavaBean, P extends JavaBeanStream<O, P>, Q extends StreamObjectBooleanQuery<O, P, Q>>
    extends JavaBeanPredicate.ObjectBooleanQuery<O, P, Q>
    implements StreamComparableQuery<O, Boolean, P, Q> {
        public StreamObjectBooleanQuery(P parent, Function<O, Boolean> getter) {
            super(parent, getter);
        }
    }

    public static class StreamPrimitiveBooleanQuery<O extends JavaBean, P extends JavaBeanStream<O, P>, Q extends StreamPrimitiveBooleanQuery<O, P, Q>>
    extends JavaBeanPredicate.PrimitiveBooleanQuery<O, P, Q>
    implements StreamComparableQuery<O, Boolean, P, Q> {
        public StreamPrimitiveBooleanQuery(P parent, Function<O, Boolean> getter) {
            super(parent, getter);
        }
    }

    public static class StreamPrimitiveObjectQuery<O extends JavaBean, V extends Comparable<V>, P extends JavaBeanStream<O, P>, Q extends StreamPrimitiveObjectQuery<O, V, P, Q>>
    extends JavaBeanPredicate.PrimitiveObjectQuery<O, V, P, Q>
    implements StreamComparableQuery<O, V, P, Q> {
        public StreamPrimitiveObjectQuery(P parent, Function<O, V> getter) {
            super(parent, getter);
        }
    }

    public static class StreamObjectQuery<O extends JavaBean, V, P extends JavaBeanStream<O, P>, Q extends StreamObjectQuery<O, V, P, Q>>
    extends JavaBeanPredicate.ObjectQuery<O, V, P, Q>
    implements StreamQuery<O, V, P, Q> {
        public StreamObjectQuery(P parent, Function<O, V> getter) {
            super(parent, getter);
        }
    }

    public static interface StreamComparableQuery<O extends JavaBean, V extends Comparable<V>, P extends JavaBeanStream<O, P>, Q extends StreamComparableQuery<O, V, P, Q>>
    extends StreamQuery<O, V, P, Q>,
    JavaBeanPredicate.ComparableQuery<O, V, P, Q> {
        default public P sort() {
            return this.addComparator(Comparator.comparing(this::getter));
        }

        default public P reservedSort() {
            return this.addComparator(Comparator.comparing(this::getter).reversed());
        }

        default public P addComparator(Comparator<O> comparator) {
            JavaBeanStream parent = (JavaBeanStream)this.parent();
            parent.addComparator(comparator);
            return (P)parent;
        }
    }

    public static interface StreamQuery<O extends JavaBean, V, P extends JavaBeanStream<O, P>, Q extends StreamQuery<O, V, P, Q>>
    extends JavaBeanPredicate.Query<O, V, P, Q> {
    }
}

