/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.bean;

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.bean.JavaBeanComparatorBuilder;
import io.ultreia.java4all.bean.definition.JavaBeanDefinition;
import io.ultreia.java4all.bean.definition.JavaBeanDefinitionStore;
import io.ultreia.java4all.util.Comparators;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class AbstractJavaBeanComparatorBuilder<O extends JavaBean, P extends JavaBeanComparatorBuilder<O>>
implements JavaBeanComparatorBuilder<O> {
    private final List<Comparator<O>> comparators;
    private final JavaBeanDefinition javaBeanDefinition;

    public AbstractJavaBeanComparatorBuilder(JavaBeanDefinition javaBeanDefinition) {
        this.javaBeanDefinition = javaBeanDefinition;
        this.comparators = new LinkedList<Comparator<O>>();
    }

    protected AbstractJavaBeanComparatorBuilder(Class<? extends JavaBeanDefinition> javaBeanDefinitionType) {
        this(JavaBeanDefinitionStore.definition(javaBeanDefinitionType));
    }

    @Override
    public void addComparator(Comparator<O> predicate) {
        this.comparators.add(predicate);
    }

    @Override
    public Optional<Comparator<O>> build() {
        return Comparators.comparator(this.comparators);
    }

    protected <V extends Comparable<V>> JavaBeanComparatorBuilder.Query<O, V, P> on(String propertyName) {
        return new JavaBeanComparatorBuilder.Query<O, V, P>(this.p(), this.getter(propertyName));
    }

    protected <V> Function<O, V> getter(String propertyName) {
        return this.javaBeanDefinition.readProperty(propertyName).getter();
    }

    protected P p() {
        return (P)this;
    }
}

