/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.yaml;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelWriter;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.maven.polyglot.io.ModelWriterSupport;
import org.sonatype.maven.polyglot.yaml.ModelRepresenter;
import org.sonatype.maven.polyglot.yaml.ModelResolver;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;

@Component(role=ModelWriter.class, hint="yaml")
public class YamlModelWriter
extends ModelWriterSupport {
    public void write(Writer output, Map<String, Object> o, Model model) throws IOException {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setIndent(2);
        dumperOptions.setWidth(80);
        Serializer serializer = new Serializer((Emitable)new Emitter(output, dumperOptions), (Resolver)new ModelResolver(), dumperOptions, Tag.MAP);
        ModelRepresenter representer = new ModelRepresenter();
        try {
            serializer.open();
            Node node = representer.represent(model);
            serializer.serialize(node);
            serializer.close();
        }
        catch (IOException e) {
            throw new YAMLException((Throwable)e);
        }
    }
}

