/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.yaml;

import java.util.regex.Matcher;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.sonatype.maven.polyglot.yaml.ModelResolver;

public class Coordinate {
    private String groupId;
    private String artifactId;
    private String version;

    public Coordinate(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public static Coordinate createCoordinate(String scalar) {
        Matcher matcher = ModelResolver.COORDINATE_PATTERN.matcher(scalar);
        if (matcher.matches()) {
            return new Coordinate(matcher.group("groupId"), matcher.group("artifactId"), matcher.group("version"));
        }
        matcher = ModelResolver.GROUP_NAME_PATTERN.matcher(scalar);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unexpected node: " + scalar);
        }
        return new Coordinate(matcher.group("groupId"), matcher.group("artifactId"), null);
    }

    public Model mergeModel(Model model) {
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        if (this.version != null) {
            model.setVersion(this.version);
        }
        return model;
    }

    public Plugin mergePlugin(Plugin plugin) {
        plugin.setGroupId(this.groupId);
        plugin.setArtifactId(this.artifactId);
        if (this.version != null) {
            plugin.setVersion(this.version);
        }
        return plugin;
    }

    public ReportPlugin mergeReportPlugin(ReportPlugin plugin) {
        plugin.setGroupId(this.groupId);
        plugin.setArtifactId(this.artifactId);
        if (this.version != null) {
            plugin.setVersion(this.version);
        }
        return plugin;
    }

    public Extension mergeExtension(Extension extension) {
        extension.setGroupId(this.groupId);
        extension.setArtifactId(this.artifactId);
        if (this.version != null) {
            extension.setVersion(this.version);
        }
        return extension;
    }

    public Parent mergeParent(Parent parent) {
        parent.setGroupId(this.groupId);
        parent.setArtifactId(this.artifactId);
        if (this.version != null) {
            parent.setVersion(this.version);
        }
        return parent;
    }
}

