/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.securityrequirement;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.securityrequirement.SecurityRequirementConstant;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class SecurityRequirementReader {
    private SecurityRequirementReader() {
    }

    public static Optional<List<SecurityRequirement>> readSecurityRequirements(AnnotationValue annotationValue) {
        if (annotationValue != null) {
            IoLogging.log.annotationsArray("@SecurityRequirement");
            AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
            ArrayList<SecurityRequirement> requirements = new ArrayList<SecurityRequirement>();
            for (AnnotationInstance requirementAnno : nestedArray) {
                SecurityRequirement requirement = SecurityRequirementReader.readSecurityRequirement(requirementAnno);
                if (requirement == null) continue;
                requirements.add(requirement);
            }
            return Optional.of(requirements);
        }
        return Optional.empty();
    }

    public static Optional<List<SecurityRequirement>> readSecurityRequirements(JsonNode node) {
        if (node != null && node.isArray()) {
            IoLogging.log.jsonArray("SecurityRequirement");
            ArrayList<SecurityRequirement> requirements = new ArrayList<SecurityRequirement>(node.size());
            ArrayNode arrayNode = (ArrayNode)node;
            for (JsonNode arrayItem : arrayNode) {
                requirements.add(SecurityRequirementReader.readSecurityRequirement(arrayItem));
            }
            return Optional.of(requirements);
        }
        return Optional.empty();
    }

    public static SecurityRequirement readSecurityRequirement(AnnotationInstance annotationInstance) {
        String name = JandexUtil.stringValue(annotationInstance, "name");
        if (name != null) {
            Optional<List<String>> maybeScopes = JandexUtil.stringListValue(annotationInstance, "scopes");
            SecurityRequirementImpl requirement = new SecurityRequirementImpl();
            if (maybeScopes.isPresent()) {
                requirement.addScheme(name, maybeScopes.get());
            } else {
                requirement.addScheme(name);
            }
            return requirement;
        }
        return null;
    }

    private static SecurityRequirement readSecurityRequirement(JsonNode node) {
        if (node != null && node.isObject()) {
            SecurityRequirementImpl requirement = new SecurityRequirementImpl();
            Iterator fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode scopesNode = node.get(fieldName);
                Optional<List<String>> maybeScopes = JsonUtil.readStringArray(scopesNode);
                if (maybeScopes.isPresent()) {
                    requirement.addScheme(fieldName, maybeScopes.get());
                    continue;
                }
                requirement.addScheme(fieldName);
            }
            return requirement;
        }
        return null;
    }

    public static AnnotationInstance getSecurityRequirementsAnnotation(AnnotationTarget target) {
        return TypeUtil.getAnnotation(target, SecurityRequirementConstant.DOTNAME_SECURITY_REQUIREMENTS);
    }

    public static List<AnnotationInstance> getSecurityRequirementAnnotations(AnnotationTarget target) {
        return JandexUtil.getRepeatableAnnotation(target, SecurityRequirementConstant.DOTNAME_SECURITY_REQUIREMENT, SecurityRequirementConstant.DOTNAME_SECURITY_REQUIREMENTS);
    }
}

