/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.util.Iterator;
import java.util.function.Function;

public final class MappedDirectoryStream<T, R>
implements DirectoryStream<R> {
    private final DirectoryStream<T> delegate;
    private final Function<T, R> mappingFunction;

    public MappedDirectoryStream(DirectoryStream<T> delegate, Function<T, R> mappingFunction) {
        this.delegate = (DirectoryStream)Assert.checkNotNullParam((String)"delegate", delegate);
        this.mappingFunction = (Function)Assert.checkNotNullParam((String)"mappingFunction", mappingFunction);
    }

    @Override
    public Iterator<R> iterator() {
        final Iterator<T> itr = this.delegate.iterator();
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public R next() {
                return MappedDirectoryStream.this.mappingFunction.apply(itr.next());
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

