/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.instruction;

import io.smallrye.classfile.Instruction;
import io.smallrye.classfile.Opcode;
import io.smallrye.classfile.TypeKind;
import io.smallrye.classfile.impl.AbstractInstruction;
import io.smallrye.classfile.impl.BytecodeHelpers;
import io.smallrye.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ReturnInstruction
extends Instruction {
    public TypeKind typeKind();

    public static ReturnInstruction of(TypeKind typeKind) {
        return ReturnInstruction.of(BytecodeHelpers.returnOpcode(typeKind));
    }

    public static ReturnInstruction of(Opcode op) {
        Util.checkKind(op, Opcode.Kind.RETURN);
        return new AbstractInstruction.UnboundReturnInstruction(op);
    }
}

