/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.instruction;

import io.smallrye.classfile.Instruction;
import io.smallrye.classfile.Opcode;
import io.smallrye.classfile.TypeKind;
import io.smallrye.classfile.impl.AbstractInstruction;
import io.smallrye.classfile.impl.BytecodeHelpers;
import io.smallrye.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConvertInstruction
extends Instruction {
    public TypeKind fromType();

    public TypeKind toType();

    public static ConvertInstruction of(TypeKind fromType, TypeKind toType) {
        return ConvertInstruction.of(BytecodeHelpers.convertOpcode(fromType, toType));
    }

    public static ConvertInstruction of(Opcode op) {
        Util.checkKind(op, Opcode.Kind.CONVERT);
        return new AbstractInstruction.UnboundConvertInstruction(op);
    }
}

