/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl.verifier;

import io.smallrye.classfile.impl.verifier.VerifierImpl;

final class VerificationSignature {
    static final char JVM_SIGNATURE_DOT = '.';
    static final char JVM_SIGNATURE_ARRAY = '[';
    static final char JVM_SIGNATURE_BYTE = 'B';
    static final char JVM_SIGNATURE_CHAR = 'C';
    static final char JVM_SIGNATURE_CLASS = 'L';
    static final char JVM_SIGNATURE_ENDCLASS = ';';
    static final char JVM_SIGNATURE_FLOAT = 'F';
    static final char JVM_SIGNATURE_DOUBLE = 'D';
    static final char JVM_SIGNATURE_FUNC = '(';
    static final char JVM_SIGNATURE_ENDFUNC = ')';
    static final char JVM_SIGNATURE_INT = 'I';
    static final char JVM_SIGNATURE_LONG = 'J';
    static final char JVM_SIGNATURE_SHORT = 'S';
    static final char JVM_SIGNATURE_VOID = 'V';
    static final char JVM_SIGNATURE_BOOLEAN = 'Z';
    private static final char[] TYPE2CHAR_TAB = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', 'Z', 'C', 'F', 'D', 'B', 'S', 'I', 'J', 'L', '[', 'V', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private BasicType type;
    private final String signature;
    private final int limit;
    private int begin;
    private int end;
    private int arrayPrefix;
    private int state;
    private static final int S_FIELD = 0;
    private static final int S_METHOD = 1;
    private static final int S_METHOD_RETURN = 3;
    private final VerifierImpl context;

    static boolean isReferenceType(BasicType t) {
        return t == BasicType.T_OBJECT || t == BasicType.T_ARRAY;
    }

    static boolean hasEnvelope(char signature_char) {
        return signature_char == 'L';
    }

    boolean atReturnType() {
        return this.state == 3;
    }

    boolean isReference() {
        return VerificationSignature.isReferenceType(this.type);
    }

    BasicType type() {
        return this.type;
    }

    private int rawSymbolBegin() {
        return this.begin + (this.hasEnvelope() ? 1 : 0);
    }

    private int rawSymbolEnd() {
        return this.end - (this.hasEnvelope() ? 1 : 0);
    }

    private boolean hasEnvelope() {
        return VerificationSignature.hasEnvelope(this.signature.charAt(this.begin));
    }

    String asSymbol() {
        int begin = this.rawSymbolBegin();
        int end = this.rawSymbolEnd();
        return this.signature.substring(begin, end);
    }

    int skipArrayPrefix(int max_skip_length) {
        if (this.type != BasicType.T_ARRAY) {
            return 0;
        }
        if (this.arrayPrefix > max_skip_length) {
            this.arrayPrefix -= max_skip_length;
            this.begin += max_skip_length;
            return max_skip_length;
        }
        return this.skipWholeArrayPrefix();
    }

    static BasicType decodeSignatureChar(char ch) {
        return BasicType.fromSignature(ch);
    }

    VerificationSignature(String signature, boolean is_method, VerifierImpl context) {
        int oz;
        this.signature = signature;
        this.limit = signature.length();
        this.state = oz = is_method ? 1 : 0;
        this.begin = this.end = oz;
        this.arrayPrefix = 0;
        this.context = context;
        this.next();
    }

    private int scanType(BasicType type) {
        int e;
        switch (type.ordinal()) {
            case 8: {
                int tem = this.signature.indexOf(59, e);
                return tem < 0 ? this.limit : tem + 1;
            }
            case 9: {
                for (e = this.end; e < this.limit && this.signature.charAt(e) == '['; ++e) {
                }
                this.arrayPrefix = e - this.end;
                if (VerificationSignature.hasEnvelope(this.signature.charAt(e))) {
                    int tem = this.signature.indexOf(59, e);
                    return tem < 0 ? this.limit : tem + 1;
                }
                return e + 1;
            }
        }
        return e + 1;
    }

    void next() {
        String sig = this.signature;
        int len = this.limit;
        this.testLen(len);
        this.begin = this.end++;
        char ch = sig.charAt(this.begin);
        if (ch == ')') {
            this.state = 3;
            this.begin = this.end;
            this.testLen(len);
            ch = sig.charAt(this.begin);
        }
        try {
            BasicType bt;
            this.type = bt = VerificationSignature.decodeSignatureChar(ch);
            this.end = this.scanType(bt);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Not a valid signature: '" + this.signature + "'", iae);
        }
    }

    private void testLen(int len) {
        if (this.end >= len) {
            if (this.context == null) {
                throw new IllegalArgumentException("Invalid signature " + this.signature);
            }
            this.context.verifyError("Invalid signature " + this.signature);
        }
    }

    int skipWholeArrayPrefix() {
        BasicType bt;
        int new_begin;
        int whole_array_prefix = this.arrayPrefix;
        this.begin = new_begin = this.begin + whole_array_prefix;
        char ch = this.signature.charAt(new_begin);
        this.type = bt = VerificationSignature.decodeSignatureChar(ch);
        return whole_array_prefix;
    }

    static int isValidType(String type, int limit) {
        int index;
        for (index = 0; index < limit && type.charAt(index) == '['; ++index) {
        }
        if (index >= limit) {
            return -1;
        }
        switch (type.charAt(index)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return index + 1;
            }
            case 'L': {
                ++index;
                while (index < limit) {
                    char c = type.charAt(index);
                    switch (c) {
                        case ';': {
                            return index + 1;
                        }
                        case '\u0000': 
                        case '.': 
                        case '[': {
                            return -1;
                        }
                    }
                    ++index;
                }
                break;
            }
        }
        return -1;
    }

    static boolean isValidMethodSignature(String method_sig) {
        if (method_sig != null) {
            int len = method_sig.length();
            int index = 0;
            if (len > 1 && method_sig.charAt(index) == '(') {
                ++index;
                while (index < len && method_sig.charAt(index) != ')') {
                    int res = VerificationSignature.isValidType(method_sig.substring(index), len - index);
                    if (res == -1) {
                        return false;
                    }
                    index += res;
                }
                if (index < len && method_sig.charAt(index) == ')') {
                    return VerificationSignature.isValidType(method_sig.substring(++index), len - index) == len - index;
                }
            }
        }
        return false;
    }

    static boolean isValidTypeSignature(String sig) {
        if (sig == null) {
            return false;
        }
        int len = sig.length();
        return len >= 1 && VerificationSignature.isValidType(sig, len) == len;
    }

    static enum BasicType {
        T_BOOLEAN(4),
        T_CHAR(5),
        T_FLOAT(6),
        T_DOUBLE(7),
        T_BYTE(8),
        T_SHORT(9),
        T_INT(10),
        T_LONG(11),
        T_OBJECT(12),
        T_ARRAY(13),
        T_VOID(14),
        T_ADDRESS(15),
        T_NARROWOOP(16),
        T_METADATA(17),
        T_NARROWKLASS(18),
        T_CONFLICT(19),
        T_ILLEGAL(99);

        final int type;

        private BasicType(int type) {
            this.type = type;
        }

        static BasicType fromSignature(char ch) {
            return switch (ch) {
                case 'Z' -> T_BOOLEAN;
                case 'C' -> T_CHAR;
                case 'F' -> T_FLOAT;
                case 'D' -> T_DOUBLE;
                case 'B' -> T_BYTE;
                case 'S' -> T_SHORT;
                case 'I' -> T_INT;
                case 'J' -> T_LONG;
                case 'L' -> T_OBJECT;
                case '[' -> T_ARRAY;
                case 'V' -> T_VOID;
                default -> throw new IllegalArgumentException("Not a valid type: '" + ch + "'");
            };
        }
    }
}

