/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Annotation;
import io.smallrye.classfile.AnnotationElement;
import io.smallrye.classfile.AnnotationValue;
import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.ClassModel;
import io.smallrye.classfile.CodeElement;
import io.smallrye.classfile.CodeModel;
import io.smallrye.classfile.CompoundElement;
import io.smallrye.classfile.FieldModel;
import io.smallrye.classfile.Instruction;
import io.smallrye.classfile.MethodModel;
import io.smallrye.classfile.TypeAnnotation;
import io.smallrye.classfile.attribute.AnnotationDefaultAttribute;
import io.smallrye.classfile.attribute.BootstrapMethodsAttribute;
import io.smallrye.classfile.attribute.CharacterRangeInfo;
import io.smallrye.classfile.attribute.CharacterRangeTableAttribute;
import io.smallrye.classfile.attribute.CodeAttribute;
import io.smallrye.classfile.attribute.ConstantValueAttribute;
import io.smallrye.classfile.attribute.EnclosingMethodAttribute;
import io.smallrye.classfile.attribute.ExceptionsAttribute;
import io.smallrye.classfile.attribute.InnerClassesAttribute;
import io.smallrye.classfile.attribute.LineNumberInfo;
import io.smallrye.classfile.attribute.LineNumberTableAttribute;
import io.smallrye.classfile.attribute.LocalVariableInfo;
import io.smallrye.classfile.attribute.LocalVariableTableAttribute;
import io.smallrye.classfile.attribute.LocalVariableTypeInfo;
import io.smallrye.classfile.attribute.LocalVariableTypeTableAttribute;
import io.smallrye.classfile.attribute.MethodParameterInfo;
import io.smallrye.classfile.attribute.MethodParametersAttribute;
import io.smallrye.classfile.attribute.ModuleAttribute;
import io.smallrye.classfile.attribute.ModuleMainClassAttribute;
import io.smallrye.classfile.attribute.ModulePackagesAttribute;
import io.smallrye.classfile.attribute.NestHostAttribute;
import io.smallrye.classfile.attribute.NestMembersAttribute;
import io.smallrye.classfile.attribute.PermittedSubclassesAttribute;
import io.smallrye.classfile.attribute.RecordAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.smallrye.classfile.attribute.SignatureAttribute;
import io.smallrye.classfile.attribute.SourceFileAttribute;
import io.smallrye.classfile.attribute.StackMapFrameInfo;
import io.smallrye.classfile.attribute.StackMapTableAttribute;
import io.smallrye.classfile.components.ClassPrinter;
import io.smallrye.classfile.constantpool.AnnotationConstantValueEntry;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.ConstantPool;
import io.smallrye.classfile.constantpool.DynamicConstantPoolEntry;
import io.smallrye.classfile.constantpool.InterfaceMethodRefEntry;
import io.smallrye.classfile.constantpool.LoadableConstantEntry;
import io.smallrye.classfile.constantpool.MemberRefEntry;
import io.smallrye.classfile.constantpool.MethodHandleEntry;
import io.smallrye.classfile.constantpool.MethodTypeEntry;
import io.smallrye.classfile.constantpool.ModuleEntry;
import io.smallrye.classfile.constantpool.NameAndTypeEntry;
import io.smallrye.classfile.constantpool.PackageEntry;
import io.smallrye.classfile.constantpool.PoolEntry;
import io.smallrye.classfile.constantpool.StringEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.StackMapDecoder;
import io.smallrye.classfile.impl.Util;
import io.smallrye.classfile.instruction.BranchInstruction;
import io.smallrye.classfile.instruction.ConstantInstruction;
import io.smallrye.classfile.instruction.DiscontinuedInstruction;
import io.smallrye.classfile.instruction.FieldInstruction;
import io.smallrye.classfile.instruction.IncrementInstruction;
import io.smallrye.classfile.instruction.InvokeDynamicInstruction;
import io.smallrye.classfile.instruction.InvokeInstruction;
import io.smallrye.classfile.instruction.LoadInstruction;
import io.smallrye.classfile.instruction.LookupSwitchInstruction;
import io.smallrye.classfile.instruction.NewMultiArrayInstruction;
import io.smallrye.classfile.instruction.NewObjectInstruction;
import io.smallrye.classfile.instruction.NewPrimitiveArrayInstruction;
import io.smallrye.classfile.instruction.NewReferenceArrayInstruction;
import io.smallrye.classfile.instruction.StoreInstruction;
import io.smallrye.classfile.instruction.TableSwitchInstruction;
import io.smallrye.classfile.instruction.TypeCheckInstruction;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class ClassPrinterImpl {
    private static final String NL = System.lineSeparator();
    private static final char[] DIGITS = "0123456789ABCDEF".toCharArray();

    private static ClassPrinter.Node leaf(ConstantDesc name, ConstantDesc value) {
        return new LeafNodeImpl(name, value);
    }

    private static ClassPrinter.Node[] leafs(ConstantDesc ... namesAndValues) {
        if ((namesAndValues.length & 1) > 0) {
            throw new AssertionError((Object)("Odd number of arguments: " + Arrays.toString(namesAndValues)));
        }
        ClassPrinter.Node[] nodes = new ClassPrinter.Node[namesAndValues.length >> 1];
        int j = 0;
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = ClassPrinterImpl.leaf(namesAndValues[j++], namesAndValues[j++]);
        }
        return nodes;
    }

    private static ClassPrinter.Node list(ConstantDesc listName, ConstantDesc itemsName, Stream<ConstantDesc> values) {
        return new ListNodeImpl(Style.FLOW, listName, values.map(v -> ClassPrinterImpl.leaf(itemsName, v)));
    }

    private static ClassPrinter.Node map(ConstantDesc mapName, ConstantDesc ... keysAndValues) {
        return new MapNodeImpl(Style.FLOW, mapName).with(ClassPrinterImpl.leafs(keysAndValues));
    }

    private static void escape(int c, StringBuilder sb) {
        switch (c) {
            case 92: {
                sb.append('\\').append('\\');
                break;
            }
            case 34: {
                sb.append('\\').append('\"');
                break;
            }
            case 8: {
                sb.append('\\').append('b');
                break;
            }
            case 10: {
                sb.append('\\').append('n');
                break;
            }
            case 9: {
                sb.append('\\').append('t');
                break;
            }
            case 12: {
                sb.append('\\').append('f');
                break;
            }
            case 13: {
                sb.append('\\').append('r');
                break;
            }
            default: {
                if (c >= 32 && c < 127) {
                    sb.append((char)c);
                    break;
                }
                sb.append('\\').append('u').append(DIGITS[c >> 12 & 0xF]).append(DIGITS[c >> 8 & 0xF]).append(DIGITS[c >> 4 & 0xF]).append(DIGITS[c & 0xF]);
            }
        }
    }

    public static void toYaml(ClassPrinter.Node node, Consumer<String> out) {
        ClassPrinterImpl.toYaml(0, false, new ListNodeImpl(Style.BLOCK, null, Stream.of(node)), out);
        out.accept(NL);
    }

    private static void toYaml(int indent, boolean skipFirstIndent, ClassPrinter.Node node, Consumer<String> out) {
        if (node instanceof ClassPrinter.LeafNode) {
            ClassPrinter.LeafNode leaf = (ClassPrinter.LeafNode)node;
            ConstantDesc v = leaf.value();
            if (ConstantDescs.BSM_NULL_CONSTANT.equals(v)) {
                out.accept("null");
            } else {
                out.accept(ClassPrinterImpl.quoteAndEscapeYaml(v));
            }
        } else if (node instanceof ListNodeImpl) {
            ListNodeImpl list = (ListNodeImpl)node;
            switch (list.style().ordinal()) {
                case 1: {
                    out.accept("[");
                    boolean first = true;
                    for (ClassPrinter.Node n : list) {
                        if (first) {
                            first = false;
                        } else {
                            out.accept(", ");
                        }
                        ClassPrinterImpl.toYaml(0, false, n, out);
                    }
                    out.accept("]");
                    break;
                }
                case 0: {
                    for (ClassPrinter.Node n : list) {
                        out.accept(NL + "    ".repeat(indent) + "  - ");
                        ClassPrinterImpl.toYaml(indent + 1, true, n, out);
                    }
                    break;
                }
            }
        } else if (node instanceof MapNodeImpl) {
            MapNodeImpl map = (MapNodeImpl)node;
            switch (map.style().ordinal()) {
                case 1: {
                    out.accept("{");
                    boolean first = true;
                    for (ClassPrinter.Node n : map.values()) {
                        if (first) {
                            first = false;
                        } else {
                            out.accept(", ");
                        }
                        out.accept(ClassPrinterImpl.quoteAndEscapeYaml(n.name()) + ": ");
                        ClassPrinterImpl.toYaml(0, false, n, out);
                    }
                    out.accept("}");
                    break;
                }
                case 0: {
                    for (ClassPrinter.Node n : map.values()) {
                        ListNodeImpl pl;
                        if (skipFirstIndent) {
                            skipFirstIndent = false;
                        } else {
                            out.accept(NL + "    ".repeat(indent));
                        }
                        out.accept(ClassPrinterImpl.quoteAndEscapeYaml(n.name()) + ": ");
                        ClassPrinterImpl.toYaml(n instanceof ListNodeImpl && (pl = (ListNodeImpl)n).style() == Style.BLOCK ? indent : indent + 1, false, n, out);
                    }
                    break;
                }
            }
        }
    }

    private static String quoteAndEscapeYaml(ConstantDesc value) {
        String s = String.valueOf(value);
        if (value instanceof Number) {
            return s;
        }
        if (s.length() == 0) {
            return "''";
        }
        if (s.equalsIgnoreCase("null")) {
            return "'" + s + "'";
        }
        StringBuilder sb = new StringBuilder(s.length() << 1);
        s.chars().forEach(c -> {
            switch (c) {
                case 39: {
                    sb.append("''");
                    break;
                }
                default: {
                    ClassPrinterImpl.escape(c, sb);
                }
            }
        });
        String esc = sb.toString();
        if (esc.length() != s.length()) {
            return "'" + esc + "'";
        }
        switch (esc.charAt(0)) {
            case '!': 
            case '\"': 
            case '#': 
            case '%': 
            case '&': 
            case '\'': 
            case '*': 
            case ',': 
            case '-': 
            case ':': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case ']': 
            case '`': 
            case '{': 
            case '|': 
            case '}': {
                return "'" + esc + "'";
            }
        }
        for (int i = 1; i < esc.length(); ++i) {
            switch (esc.charAt(i)) {
                case ',': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return "'" + esc + "'";
                }
            }
        }
        return esc;
    }

    public static void toJson(ClassPrinter.Node node, Consumer<String> out) {
        ClassPrinterImpl.toJson(1, true, node, out);
        out.accept(NL);
    }

    private static void toJson(int indent, boolean skipFirstIndent, ClassPrinter.Node node, Consumer<String> out) {
        if (node instanceof ClassPrinter.LeafNode) {
            ClassPrinter.LeafNode leaf = (ClassPrinter.LeafNode)node;
            ConstantDesc v = leaf.value();
            if (ConstantDescs.BSM_NULL_CONSTANT.equals(v)) {
                out.accept("null");
            } else {
                out.accept(ClassPrinterImpl.quoteAndEscapeYaml(v));
            }
        } else if (node instanceof ListNodeImpl) {
            ListNodeImpl list = (ListNodeImpl)node;
            out.accept("[");
            boolean first = true;
            switch (list.style().ordinal()) {
                case 1: {
                    for (ClassPrinter.Node n : list) {
                        if (first) {
                            first = false;
                        } else {
                            out.accept(", ");
                        }
                        ClassPrinterImpl.toJson(0, false, n, out);
                    }
                    break;
                }
                case 0: {
                    for (ClassPrinter.Node n : list) {
                        if (first) {
                            first = false;
                        } else {
                            out.accept(",");
                        }
                        out.accept(NL + "    ".repeat(indent));
                        ClassPrinterImpl.toJson(indent + 1, true, n, out);
                    }
                    break;
                }
            }
            out.accept("]");
        } else if (node instanceof MapNodeImpl) {
            MapNodeImpl map = (MapNodeImpl)node;
            switch (map.style().ordinal()) {
                case 1: {
                    out.accept("{");
                    boolean first = true;
                    for (ClassPrinter.Node n : map.values()) {
                        if (first) {
                            first = false;
                        } else {
                            out.accept(", ");
                        }
                        out.accept(ClassPrinterImpl.quoteAndEscapeJson((ConstantDesc)((Object)n.name().toString())) + ": ");
                        ClassPrinterImpl.toJson(0, false, n, out);
                    }
                    break;
                }
                case 0: {
                    if (skipFirstIndent) {
                        out.accept("  { ");
                    } else {
                        out.accept("{");
                    }
                    boolean first = true;
                    for (ClassPrinter.Node n : map.values()) {
                        if (first) {
                            first = false;
                        } else {
                            out.accept(",");
                        }
                        if (skipFirstIndent) {
                            skipFirstIndent = false;
                        } else {
                            out.accept(NL + "    ".repeat(indent));
                        }
                        out.accept(ClassPrinterImpl.quoteAndEscapeJson((ConstantDesc)((Object)n.name().toString())) + ": ");
                        ClassPrinterImpl.toJson(indent + 1, false, n, out);
                    }
                    break;
                }
            }
            out.accept("}");
        }
    }

    private static String quoteAndEscapeJson(ConstantDesc value) {
        String s = String.valueOf(value);
        if (value instanceof Number) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() << 1);
        sb.append('\"');
        s.chars().forEach(c -> ClassPrinterImpl.escape(c, sb));
        sb.append('\"');
        return sb.toString();
    }

    public static void toXml(ClassPrinter.Node node, Consumer<String> out) {
        out.accept("<?xml version = '1.0'?>");
        ClassPrinterImpl.toXml(0, false, node, out);
        out.accept(NL);
    }

    private static void toXml(int indent, boolean skipFirstIndent, ClassPrinter.Node node, Consumer<String> out) {
        String name;
        block18: {
            block19: {
                block17: {
                    name = ClassPrinterImpl.toXmlName(node.name().toString());
                    if (!(node instanceof ClassPrinter.LeafNode)) break block17;
                    ClassPrinter.LeafNode leaf = (ClassPrinter.LeafNode)node;
                    out.accept("<" + name + ">");
                    ConstantDesc v = leaf.value();
                    if (ConstantDescs.BSM_NULL_CONSTANT.equals(v)) {
                        out.accept("<null/>");
                    } else {
                        out.accept(ClassPrinterImpl.xmlEscape(v));
                    }
                    break block18;
                }
                if (!(node instanceof ListNodeImpl)) break block19;
                ListNodeImpl list = (ListNodeImpl)node;
                switch (list.style().ordinal()) {
                    case 1: {
                        out.accept("<" + name + ">");
                        for (ClassPrinter.Node n : list) {
                            ClassPrinterImpl.toXml(0, false, n, out);
                        }
                        break block18;
                    }
                    case 0: {
                        if (!skipFirstIndent) {
                            out.accept(NL + "    ".repeat(indent));
                        }
                        out.accept("<" + name + ">");
                        for (ClassPrinter.Node n : list) {
                            out.accept(NL + "    ".repeat(indent + 1));
                            ClassPrinterImpl.toXml(indent + 1, true, n, out);
                        }
                        break;
                    }
                }
                break block18;
            }
            if (node instanceof MapNodeImpl) {
                MapNodeImpl map = (MapNodeImpl)node;
                switch (map.style().ordinal()) {
                    case 1: {
                        out.accept("<" + name + ">");
                        for (ClassPrinter.Node n : map.values()) {
                            ClassPrinterImpl.toXml(0, false, n, out);
                        }
                        break;
                    }
                    case 0: {
                        if (!skipFirstIndent) {
                            out.accept(NL + "    ".repeat(indent));
                        }
                        out.accept("<" + name + ">");
                        for (ClassPrinter.Node n : map.values()) {
                            out.accept(NL + "    ".repeat(indent + 1));
                            ClassPrinterImpl.toXml(indent + 1, true, n, out);
                        }
                        break;
                    }
                }
            }
        }
        out.accept("</" + name + ">");
    }

    private static String xmlEscape(ConstantDesc value) {
        String s = String.valueOf(value);
        StringBuilder sb = new StringBuilder(s.length() << 1);
        s.chars().forEach(c -> {
            switch (c) {
                case 60: {
                    sb.append("&lt;");
                    break;
                }
                case 62: {
                    sb.append("&gt;");
                    break;
                }
                case 34: {
                    sb.append("&quot;");
                    break;
                }
                case 38: {
                    sb.append("&amp;");
                    break;
                }
                case 39: {
                    sb.append("&apos;");
                    break;
                }
                default: {
                    ClassPrinterImpl.escape(c, sb);
                }
            }
        });
        return sb.toString();
    }

    private static String toXmlName(String name) {
        if (Character.isDigit(((String)name).charAt(0))) {
            name = "_" + (String)name;
        }
        return ((String)name).replaceAll("[^A-Za-z_0-9]", "_");
    }

    private static ClassPrinter.Node[] elementValueToTree(AnnotationValue v) {
        if (v instanceof AnnotationValue.OfString) {
            AnnotationValue.OfString cv = (AnnotationValue.OfString)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"string", String.valueOf(cv.stringValue())});
        }
        if (v instanceof AnnotationValue.OfDouble) {
            AnnotationValue.OfDouble cv = (AnnotationValue.OfDouble)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"double", String.valueOf(cv.doubleValue())});
        }
        if (v instanceof AnnotationValue.OfFloat) {
            AnnotationValue.OfFloat cv = (AnnotationValue.OfFloat)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"float", String.valueOf(cv.floatValue())});
        }
        if (v instanceof AnnotationValue.OfLong) {
            AnnotationValue.OfLong cv = (AnnotationValue.OfLong)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"long", String.valueOf(cv.longValue())});
        }
        if (v instanceof AnnotationValue.OfInt) {
            AnnotationValue.OfInt cv = (AnnotationValue.OfInt)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"int", String.valueOf(cv.intValue())});
        }
        if (v instanceof AnnotationValue.OfShort) {
            AnnotationValue.OfShort cv = (AnnotationValue.OfShort)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"short", String.valueOf(cv.shortValue())});
        }
        if (v instanceof AnnotationValue.OfChar) {
            AnnotationValue.OfChar cv = (AnnotationValue.OfChar)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"char", String.valueOf(cv.charValue())});
        }
        if (v instanceof AnnotationValue.OfByte) {
            AnnotationValue.OfByte cv = (AnnotationValue.OfByte)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"byte", String.valueOf(cv.byteValue())});
        }
        if (v instanceof AnnotationValue.OfBoolean) {
            AnnotationValue.OfBoolean cv = (AnnotationValue.OfBoolean)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"boolean", String.valueOf(cv.booleanValue())});
        }
        if (v instanceof AnnotationValue.OfClass) {
            AnnotationValue.OfClass clv = (AnnotationValue.OfClass)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"class", clv.className().stringValue()});
        }
        if (v instanceof AnnotationValue.OfEnum) {
            AnnotationValue.OfEnum ev2 = (AnnotationValue.OfEnum)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"enum class", ev2.className().stringValue(), "constant name", ev2.constantName().stringValue()});
        }
        if (v instanceof AnnotationValue.OfAnnotation) {
            AnnotationValue.OfAnnotation av = (AnnotationValue.OfAnnotation)v;
            return ClassPrinterImpl.leafs(new ConstantDesc[]{"annotation class", av.annotation().className().stringValue()});
        }
        if (v instanceof AnnotationValue.OfArray) {
            AnnotationValue.OfArray av = (AnnotationValue.OfArray)v;
            return new ClassPrinter.Node[]{new ListNodeImpl(Style.FLOW, (ConstantDesc)((Object)"array"), av.values().stream().map(ev -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"value")).with(ClassPrinterImpl.elementValueToTree(ev))))};
        }
        throw new IllegalStateException();
    }

    private static ClassPrinter.Node elementValuePairsToTree(List<AnnotationElement> evps) {
        return new ListNodeImpl(Style.FLOW, (ConstantDesc)((Object)"values"), evps.stream().map(evp -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"pair")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"name"), (ConstantDesc)((Object)evp.name().stringValue())), new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"value")).with(ClassPrinterImpl.elementValueToTree(evp.value())))));
    }

    private static Stream<ConstantDesc> convertVTIs(CodeAttribute lr, List<StackMapFrameInfo.VerificationTypeInfo> vtis) {
        return vtis.stream().mapMulti((vti, ret) -> {
            if (vti instanceof StackMapFrameInfo.SimpleVerificationTypeInfo) {
                StackMapFrameInfo.SimpleVerificationTypeInfo s = (StackMapFrameInfo.SimpleVerificationTypeInfo)vti;
                switch (s) {
                    case DOUBLE: {
                        ret.accept("double");
                        ret.accept("double2");
                        break;
                    }
                    case FLOAT: {
                        ret.accept("float");
                        break;
                    }
                    case INTEGER: {
                        ret.accept("int");
                        break;
                    }
                    case LONG: {
                        ret.accept("long");
                        ret.accept("long2");
                        break;
                    }
                    case NULL: {
                        ret.accept(ConstantDescs.BSM_NULL_CONSTANT);
                        break;
                    }
                    case TOP: {
                        ret.accept("?");
                        break;
                    }
                    case UNINITIALIZED_THIS: {
                        ret.accept("THIS");
                    }
                }
            } else if (vti instanceof StackMapFrameInfo.ObjectVerificationTypeInfo) {
                StackMapFrameInfo.ObjectVerificationTypeInfo o = (StackMapFrameInfo.ObjectVerificationTypeInfo)vti;
                ret.accept(o.className().name().stringValue());
            } else if (vti instanceof StackMapFrameInfo.UninitializedVerificationTypeInfo) {
                StackMapFrameInfo.UninitializedVerificationTypeInfo u = (StackMapFrameInfo.UninitializedVerificationTypeInfo)vti;
                ret.accept("UNINITIALIZED @" + lr.labelToBci(u.newTarget()));
            }
        });
    }

    public static ClassPrinter.MapNode modelToTree(CompoundElement<?> model, ClassPrinter.Verbosity verbosity) {
        Objects.requireNonNull(verbosity);
        if (model instanceof ClassModel) {
            ClassModel cm = (ClassModel)model;
            return ClassPrinterImpl.classToTree(cm, verbosity);
        }
        if (model instanceof FieldModel) {
            FieldModel fm = (FieldModel)model;
            return ClassPrinterImpl.fieldToTree(fm, verbosity);
        }
        if (model instanceof MethodModel) {
            MethodModel mm = (MethodModel)model;
            return ClassPrinterImpl.methodToTree(mm, verbosity);
        }
        if (model instanceof CodeModel) {
            CodeModel com = (CodeModel)model;
            return ClassPrinterImpl.codeToTree((CodeAttribute)com, verbosity);
        }
        throw new IllegalStateException();
    }

    private static ClassPrinter.MapNode classToTree(ClassModel clm, ClassPrinter.Verbosity verbosity) {
        return new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"class")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"class name"), (ConstantDesc)((Object)clm.thisClass().asInternalName())), ClassPrinterImpl.leaf((ConstantDesc)((Object)"version"), (ConstantDesc)((Object)(clm.majorVersion() + "." + clm.minorVersion()))), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), clm.flags().flags().stream().map(Enum::name)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"superclass"), (ConstantDesc)((Object)clm.superclass().map(ClassEntry::asInternalName).orElse(""))), ClassPrinterImpl.list((ConstantDesc)((Object)"interfaces"), (ConstantDesc)((Object)"interface"), clm.interfaces().stream().map(ClassEntry::asInternalName)), ClassPrinterImpl.list((ConstantDesc)((Object)"attributes"), (ConstantDesc)((Object)"attribute"), clm.attributes().stream().map(Attribute::attributeName).map(Utf8Entry::stringValue))).with(ClassPrinterImpl.constantPoolToTree(clm.constantPool(), verbosity)).with(ClassPrinterImpl.attributesToTree(clm.attributes(), verbosity)).with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"fields"), clm.fields().stream().map(f -> ClassPrinterImpl.fieldToTree(f, verbosity)))).with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"methods"), clm.methods().stream().map(mm -> ClassPrinterImpl.methodToTree(mm, verbosity))));
    }

    private static ClassPrinter.Node[] constantPoolToTree(ConstantPool cp, ClassPrinter.Verbosity verbosity) {
        if (verbosity == ClassPrinter.Verbosity.TRACE_ALL) {
            MapNodeImpl cpNode = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"constant pool"));
            for (PoolEntry e : cp) {
                ClassPrinter.Node[] nodeArray;
                ClassPrinter.Node[] nodeArray2 = new ClassPrinter.Node[1];
                MapNodeImpl mapNodeImpl = new MapNodeImpl(Style.FLOW, Integer.valueOf(e.index()));
                ClassPrinter.Node[] nodeArray3 = new ClassPrinter.Node[1];
                nodeArray3[0] = ClassPrinterImpl.leaf((ConstantDesc)((Object)"tag"), (ConstantDesc)((Object)(switch (e.tag()) {
                    case 1 -> "Utf8";
                    case 3 -> "Integer";
                    case 4 -> "Float";
                    case 5 -> "Long";
                    case 6 -> "Double";
                    case 7 -> "Class";
                    case 8 -> "String";
                    case 9 -> "Fieldref";
                    case 10 -> "Methodref";
                    case 11 -> "InterfaceMethodref";
                    case 12 -> "NameAndType";
                    case 15 -> "MethodHandle";
                    case 16 -> "MethodType";
                    case 17 -> "Dynamic";
                    case 18 -> "InvokeDynamic";
                    case 19 -> "Module";
                    case 20 -> "Package";
                    default -> throw new AssertionError((Object)("Unknown CP tag: " + e.tag()));
                })));
                MapNodeImpl mapNodeImpl2 = mapNodeImpl.with(nodeArray3);
                if (e instanceof ClassEntry) {
                    ClassEntry ce = (ClassEntry)e;
                    nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"class name index", Integer.valueOf(ce.name().index()), "class internal name", ce.asInternalName()});
                } else if (e instanceof ModuleEntry) {
                    ModuleEntry me = (ModuleEntry)e;
                    nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"module name index", Integer.valueOf(me.name().index()), "module name", me.name().stringValue()});
                } else if (e instanceof PackageEntry) {
                    PackageEntry pe = (PackageEntry)e;
                    nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"package name index", Integer.valueOf(pe.name().index()), "package name", pe.name().stringValue()});
                } else if (e instanceof StringEntry) {
                    StringEntry se = (StringEntry)e;
                    nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"value index", Integer.valueOf(se.utf8().index()), "value", se.stringValue()});
                } else if (e instanceof MemberRefEntry) {
                    MemberRefEntry mre = (MemberRefEntry)e;
                    nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"owner index", Integer.valueOf(mre.owner().index()), "name and type index", Integer.valueOf(mre.nameAndType().index()), "owner", mre.owner().name().stringValue(), "name", mre.name().stringValue(), "type", mre.type().stringValue()});
                } else if (e instanceof NameAndTypeEntry) {
                    NameAndTypeEntry nte = (NameAndTypeEntry)e;
                    nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"name index", Integer.valueOf(nte.name().index()), "type index", Integer.valueOf(nte.type().index()), "name", nte.name().stringValue(), "type", nte.type().stringValue()});
                } else if (e instanceof MethodHandleEntry) {
                    MethodHandleEntry mhe = (MethodHandleEntry)e;
                    nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"reference kind", DirectMethodHandleDesc.Kind.valueOf(mhe.kind()).name(), "reference index", Integer.valueOf(mhe.reference().index()), "owner", mhe.reference().owner().asInternalName(), "name", mhe.reference().name().stringValue(), "type", mhe.reference().type().stringValue()});
                } else if (e instanceof MethodTypeEntry) {
                    MethodTypeEntry mte = (MethodTypeEntry)e;
                    nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"descriptor index", Integer.valueOf(mte.descriptor().index()), "descriptor", mte.descriptor().stringValue()});
                } else if (e instanceof DynamicConstantPoolEntry) {
                    DynamicConstantPoolEntry dcpe = (DynamicConstantPoolEntry)e;
                    ClassPrinter.Node[] nodeArray4 = new ClassPrinter.Node[5];
                    nodeArray4[0] = ClassPrinterImpl.leaf((ConstantDesc)((Object)"bootstrap method handle index"), Integer.valueOf(dcpe.bootstrap().bootstrapMethod().index()));
                    nodeArray4[1] = ClassPrinterImpl.list((ConstantDesc)((Object)"bootstrap method arguments indexes"), (ConstantDesc)((Object)"index"), dcpe.bootstrap().arguments().stream().map(en -> Integer.valueOf(en.index())));
                    nodeArray4[2] = ClassPrinterImpl.leaf((ConstantDesc)((Object)"name and type index"), Integer.valueOf(dcpe.nameAndType().index()));
                    nodeArray4[3] = ClassPrinterImpl.leaf((ConstantDesc)((Object)"name"), (ConstantDesc)((Object)dcpe.name().stringValue()));
                    nodeArray = nodeArray4;
                    nodeArray4[4] = ClassPrinterImpl.leaf((ConstantDesc)((Object)"type"), (ConstantDesc)((Object)dcpe.type().stringValue()));
                } else if (e instanceof AnnotationConstantValueEntry) {
                    AnnotationConstantValueEntry ve = (AnnotationConstantValueEntry)e;
                    nodeArray = ClassPrinterImpl.leafs(new ConstantDesc[]{"value", String.valueOf(ve.constantValue())});
                } else {
                    nodeArray = null;
                }
                nodeArray2[0] = mapNodeImpl2.with(nodeArray);
                cpNode.with(nodeArray2);
            }
            return new ClassPrinter.Node[]{cpNode};
        }
        return new ClassPrinter.Node[0];
    }

    private static ClassPrinter.Node frameToTree(ConstantDesc name, CodeAttribute lr, StackMapFrameInfo f) {
        return new MapNodeImpl(Style.FLOW, name).with(ClassPrinterImpl.list((ConstantDesc)((Object)"locals"), (ConstantDesc)((Object)"item"), ClassPrinterImpl.convertVTIs(lr, f.locals())), ClassPrinterImpl.list((ConstantDesc)((Object)"stack"), (ConstantDesc)((Object)"item"), ClassPrinterImpl.convertVTIs(lr, f.stack())));
    }

    private static ClassPrinter.MapNode fieldToTree(FieldModel f, ClassPrinter.Verbosity verbosity) {
        return new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"field")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"field name"), (ConstantDesc)((Object)f.fieldName().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), f.flags().flags().stream().map(Enum::name)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"field type"), (ConstantDesc)((Object)f.fieldType().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"attributes"), (ConstantDesc)((Object)"attribute"), f.attributes().stream().map(Attribute::attributeName).map(Utf8Entry::stringValue))).with(ClassPrinterImpl.attributesToTree(f.attributes(), verbosity));
    }

    public static ClassPrinter.MapNode methodToTree(MethodModel m, ClassPrinter.Verbosity verbosity) {
        return new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"method")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"method name"), (ConstantDesc)((Object)m.methodName().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), m.flags().flags().stream().map(Enum::name)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"method type"), (ConstantDesc)((Object)m.methodType().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"attributes"), (ConstantDesc)((Object)"attribute"), m.attributes().stream().map(Attribute::attributeName).map(Utf8Entry::stringValue))).with(ClassPrinterImpl.attributesToTree(m.attributes(), verbosity)).with(ClassPrinterImpl.codeToTree(m.code().orElse(null), verbosity));
    }

    private static ClassPrinter.MapNode codeToTree(CodeAttribute com, ClassPrinter.Verbosity verbosity) {
        if (verbosity != ClassPrinter.Verbosity.MEMBERS_ONLY && com != null) {
            MapNodeImpl codeNode = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"code"));
            codeNode.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"max stack"), Integer.valueOf(com.maxStack())));
            codeNode.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"max locals"), Integer.valueOf(com.maxLocals())));
            codeNode.with(ClassPrinterImpl.list((ConstantDesc)((Object)"attributes"), (ConstantDesc)((Object)"attribute"), com.attributes().stream().map(Attribute::attributeName).map(Utf8Entry::stringValue)));
            MapNodeImpl stackMap = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"stack map frames"));
            LinkedHashMap visibleTypeAnnos = new LinkedHashMap();
            LinkedHashMap invisibleTypeAnnos = new LinkedHashMap();
            List<Object> locals = List.of();
            for (Attribute<?> attr : com.attributes()) {
                if (attr instanceof StackMapTableAttribute) {
                    StackMapTableAttribute smta = (StackMapTableAttribute)attr;
                    codeNode.with(stackMap);
                    for (StackMapFrameInfo smf : smta.entries()) {
                        stackMap.with(ClassPrinterImpl.frameToTree(Integer.valueOf(com.labelToBci(smf.target())), com, smf));
                    }
                    continue;
                }
                if (verbosity != ClassPrinter.Verbosity.TRACE_ALL || attr == null) continue;
                if (attr instanceof LocalVariableTableAttribute) {
                    LocalVariableTableAttribute lvta = (LocalVariableTableAttribute)attr;
                    locals = lvta.localVariables();
                    codeNode.with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"local variables"), IntStream.range(0, locals.size()).mapToObj(i -> {
                        LocalVariableInfo lv = lvta.localVariables().get(i);
                        return ClassPrinterImpl.map(Integer.valueOf(i + 1), new ConstantDesc[]{"start", Integer.valueOf(lv.startPc()), "end", Integer.valueOf(lv.startPc() + lv.length()), "slot", Integer.valueOf(lv.slot()), "name", lv.name().stringValue(), "type", lv.type().stringValue()});
                    })));
                    continue;
                }
                if (attr instanceof LocalVariableTypeTableAttribute) {
                    LocalVariableTypeTableAttribute lvtta = (LocalVariableTypeTableAttribute)attr;
                    codeNode.with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"local variable types"), IntStream.range(0, lvtta.localVariableTypes().size()).mapToObj(i -> {
                        LocalVariableTypeInfo lvt = lvtta.localVariableTypes().get(i);
                        return ClassPrinterImpl.map(Integer.valueOf(i + 1), new ConstantDesc[]{"start", Integer.valueOf(lvt.startPc()), "end", Integer.valueOf(lvt.startPc() + lvt.length()), "slot", Integer.valueOf(lvt.slot()), "name", lvt.name().stringValue(), "signature", lvt.signature().stringValue()});
                    })));
                    continue;
                }
                if (attr instanceof LineNumberTableAttribute) {
                    LineNumberTableAttribute lnta = (LineNumberTableAttribute)attr;
                    codeNode.with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"line numbers"), IntStream.range(0, lnta.lineNumbers().size()).mapToObj(i -> {
                        LineNumberInfo ln = lnta.lineNumbers().get(i);
                        return ClassPrinterImpl.map(Integer.valueOf(i + 1), new ConstantDesc[]{"start", Integer.valueOf(ln.startPc()), "line number", Integer.valueOf(ln.lineNumber())});
                    })));
                    continue;
                }
                if (attr instanceof CharacterRangeTableAttribute) {
                    CharacterRangeTableAttribute crta = (CharacterRangeTableAttribute)attr;
                    codeNode.with(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"character ranges"), IntStream.range(0, crta.characterRangeTable().size()).mapToObj(i -> {
                        CharacterRangeInfo cr = crta.characterRangeTable().get(i);
                        return ClassPrinterImpl.map(Integer.valueOf(i + 1), new ConstantDesc[]{"start", Integer.valueOf(cr.startPc()), "end", Integer.valueOf(cr.endPc()), "range start", Integer.valueOf(cr.characterRangeStart()), "range end", Integer.valueOf(cr.characterRangeEnd()), "flags", Integer.valueOf(cr.flags())});
                    })));
                    continue;
                }
                if (attr instanceof RuntimeVisibleTypeAnnotationsAttribute) {
                    RuntimeVisibleTypeAnnotationsAttribute rvtaa = (RuntimeVisibleTypeAnnotationsAttribute)attr;
                    rvtaa.annotations().forEach(a -> ClassPrinterImpl.forEachOffset(a, com, (off, an) -> visibleTypeAnnos.computeIfAbsent(off, o -> new LinkedList()).add(an)));
                    continue;
                }
                if (!(attr instanceof RuntimeInvisibleTypeAnnotationsAttribute)) continue;
                RuntimeInvisibleTypeAnnotationsAttribute ritaa = (RuntimeInvisibleTypeAnnotationsAttribute)attr;
                ritaa.annotations().forEach(a -> ClassPrinterImpl.forEachOffset(a, com, (off, an) -> invisibleTypeAnnos.computeIfAbsent(off, o -> new LinkedList()).add(an)));
            }
            codeNode.with(ClassPrinterImpl.attributesToTree(com.attributes(), verbosity));
            if (!stackMap.containsKey(0)) {
                codeNode.with(new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"//stack map frame @0")).with(ClassPrinterImpl.list((ConstantDesc)((Object)"locals"), (ConstantDesc)((Object)"item"), ClassPrinterImpl.convertVTIs(com, StackMapDecoder.initFrameLocals(com.parent().get()))), ClassPrinterImpl.list((ConstantDesc)((Object)"stack"), (ConstantDesc)((Object)"item"), Stream.of(new ConstantDesc[0]))));
            }
            List<ExceptionHandler> excHandlers = com.exceptionHandlers().stream().map(exc -> new ExceptionHandler(com.labelToBci(exc.tryStart()), com.labelToBci(exc.tryEnd()), com.labelToBci(exc.handler()), exc.catchType().map(ct -> ct.name().stringValue()).orElse(null))).toList();
            int bci = 0;
            for (CodeElement coe : com) {
                List annos;
                if (!(coe instanceof Instruction)) continue;
                Instruction ins = (Instruction)coe;
                ClassPrinter.Node frame = stackMap.get(bci);
                if (frame != null) {
                    codeNode.with(new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)("//stack map frame @" + bci))).with(((MapNodeImpl)frame).values().toArray(new ClassPrinter.Node[2])));
                }
                if ((annos = (List)invisibleTypeAnnos.get(bci)) != null) {
                    codeNode.with(ClassPrinterImpl.typeAnnotationsToTree(Style.FLOW, "//invisible type annotations @" + bci, annos));
                }
                if ((annos = (List)visibleTypeAnnos.get(bci)) != null) {
                    codeNode.with(ClassPrinterImpl.typeAnnotationsToTree(Style.FLOW, "//visible type annotations @" + bci, annos));
                }
                for (int i2 = 0; i2 < excHandlers.size(); ++i2) {
                    ExceptionHandler exc2 = excHandlers.get(i2);
                    if (exc2.start() == bci) {
                        codeNode.with(ClassPrinterImpl.map((ConstantDesc)((Object)("//try block " + (i2 + 1) + " start")), new ConstantDesc[]{"start", Integer.valueOf(exc2.start()), "end", Integer.valueOf(exc2.end()), "handler", Integer.valueOf(exc2.handler()), "catch type", exc2.catchType()}));
                    }
                    if (exc2.end() == bci) {
                        codeNode.with(ClassPrinterImpl.map((ConstantDesc)((Object)("//try block " + (i2 + 1) + " end")), new ConstantDesc[]{"start", Integer.valueOf(exc2.start()), "end", Integer.valueOf(exc2.end()), "handler", Integer.valueOf(exc2.handler()), "catch type", exc2.catchType()}));
                    }
                    if (exc2.handler() != bci) continue;
                    codeNode.with(ClassPrinterImpl.map((ConstantDesc)((Object)("//exception handler " + (i2 + 1) + " start")), new ConstantDesc[]{"start", Integer.valueOf(exc2.start()), "end", Integer.valueOf(exc2.end()), "handler", Integer.valueOf(exc2.handler()), "catch type", exc2.catchType()}));
                }
                MapNodeImpl in = new MapNodeImpl(Style.FLOW, Integer.valueOf(bci)).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"opcode"), (ConstantDesc)((Object)ins.opcode().name())));
                codeNode.with(in);
                if (coe instanceof IncrementInstruction) {
                    IncrementInstruction inc = (IncrementInstruction)coe;
                    in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"slot", Integer.valueOf(inc.slot()), "const", Integer.valueOf(inc.constant())})).with(ClassPrinterImpl.localInfoToTree(locals, inc.slot(), bci));
                } else if (coe instanceof LoadInstruction) {
                    LoadInstruction lv = (LoadInstruction)coe;
                    in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"slot"), Integer.valueOf(lv.slot()))).with(ClassPrinterImpl.localInfoToTree(locals, lv.slot(), bci));
                } else if (coe instanceof StoreInstruction) {
                    StoreInstruction lv = (StoreInstruction)coe;
                    in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"slot"), Integer.valueOf(lv.slot()))).with(ClassPrinterImpl.localInfoToTree(locals, lv.slot(), bci));
                } else if (coe instanceof FieldInstruction) {
                    FieldInstruction fa = (FieldInstruction)coe;
                    in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"owner", fa.owner().name().stringValue(), "field name", fa.name().stringValue(), "field type", fa.type().stringValue()}));
                } else if (coe instanceof InvokeInstruction) {
                    InvokeInstruction inv = (InvokeInstruction)coe;
                    in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"owner", inv.owner().name().stringValue(), "method name", inv.name().stringValue(), "method type", inv.type().stringValue()}));
                } else if (coe instanceof InvokeDynamicInstruction) {
                    InvokeDynamicInstruction invd = (InvokeDynamicInstruction)coe;
                    in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"name", invd.name().stringValue(), "descriptor", invd.type().stringValue(), "bootstrap method", invd.bootstrapMethod().kind().name() + " " + Util.toInternalName(invd.bootstrapMethod().owner()) + "::" + invd.bootstrapMethod().methodName()}));
                    in.with(ClassPrinterImpl.list((ConstantDesc)((Object)"arguments"), (ConstantDesc)((Object)"arg"), invd.bootstrapArgs().stream()));
                } else if (coe instanceof NewObjectInstruction) {
                    NewObjectInstruction newo = (NewObjectInstruction)coe;
                    in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"type"), (ConstantDesc)((Object)newo.className().name().stringValue())));
                } else if (coe instanceof NewPrimitiveArrayInstruction) {
                    NewPrimitiveArrayInstruction newa = (NewPrimitiveArrayInstruction)coe;
                    in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"dimensions", Integer.valueOf(1), "descriptor", newa.typeKind().upperBound().displayName()}));
                } else if (coe instanceof NewReferenceArrayInstruction) {
                    NewReferenceArrayInstruction newa = (NewReferenceArrayInstruction)coe;
                    in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"dimensions", Integer.valueOf(1), "descriptor", newa.componentType().name().stringValue()}));
                } else if (coe instanceof NewMultiArrayInstruction) {
                    NewMultiArrayInstruction newa = (NewMultiArrayInstruction)coe;
                    in.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"dimensions", Integer.valueOf(newa.dimensions()), "descriptor", newa.arrayType().name().stringValue()}));
                } else if (coe instanceof TypeCheckInstruction) {
                    TypeCheckInstruction tch = (TypeCheckInstruction)coe;
                    in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"type"), (ConstantDesc)((Object)tch.type().name().stringValue())));
                } else if (coe instanceof ConstantInstruction) {
                    ConstantInstruction cons = (ConstantInstruction)coe;
                    in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"constant value"), cons.constantValue()));
                } else if (coe instanceof BranchInstruction) {
                    BranchInstruction br = (BranchInstruction)coe;
                    in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"target"), Integer.valueOf(com.labelToBci(br.target()))));
                } else if (coe instanceof LookupSwitchInstruction) {
                    LookupSwitchInstruction si = (LookupSwitchInstruction)coe;
                    ClassPrinter.Node[] nodeArray = new ClassPrinter.Node[1];
                    nodeArray[0] = ClassPrinterImpl.list((ConstantDesc)((Object)"targets"), (ConstantDesc)((Object)"target"), Stream.concat(Stream.of(si.defaultTarget()).map(com::labelToBci), si.cases().stream().map(sc -> com.labelToBci(sc.target()))));
                    in.with(nodeArray);
                } else if (coe instanceof TableSwitchInstruction) {
                    TableSwitchInstruction si = (TableSwitchInstruction)coe;
                    ClassPrinter.Node[] nodeArray = new ClassPrinter.Node[1];
                    nodeArray[0] = ClassPrinterImpl.list((ConstantDesc)((Object)"targets"), (ConstantDesc)((Object)"target"), Stream.concat(Stream.of(si.defaultTarget()).map(com::labelToBci), si.cases().stream().map(sc -> com.labelToBci(sc.target()))));
                    in.with(nodeArray);
                } else if (coe instanceof DiscontinuedInstruction.JsrInstruction) {
                    DiscontinuedInstruction.JsrInstruction jsr = (DiscontinuedInstruction.JsrInstruction)coe;
                    in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"target"), Integer.valueOf(com.labelToBci(jsr.target()))));
                } else if (coe instanceof DiscontinuedInstruction.RetInstruction) {
                    DiscontinuedInstruction.RetInstruction ret = (DiscontinuedInstruction.RetInstruction)coe;
                    in.with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"slot"), Integer.valueOf(ret.slot())));
                }
                bci += ins.sizeInBytes();
            }
            if (!excHandlers.isEmpty()) {
                MapNodeImpl handlersNode = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"exception handlers"));
                codeNode.with(handlersNode);
                for (int i3 = 0; i3 < excHandlers.size(); ++i3) {
                    ExceptionHandler exc3 = excHandlers.get(i3);
                    handlersNode.with(ClassPrinterImpl.map((ConstantDesc)((Object)("handler " + (i3 + 1))), new ConstantDesc[]{"start", Integer.valueOf(exc3.start()), "end", Integer.valueOf(exc3.end()), "handler", Integer.valueOf(exc3.handler()), "type", exc3.catchType()}));
                }
            }
            return codeNode;
        }
        return null;
    }

    private static ClassPrinter.Node[] attributesToTree(List<Attribute<?>> attributes, ClassPrinter.Verbosity verbosity) {
        LinkedList<ClassPrinter.Node> nodes = new LinkedList<ClassPrinter.Node>();
        if (verbosity != ClassPrinter.Verbosity.MEMBERS_ONLY) {
            for (Attribute<?> attr : attributes) {
                if (attr instanceof BootstrapMethodsAttribute) {
                    BootstrapMethodsAttribute bma = (BootstrapMethodsAttribute)attr;
                    nodes.add(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"bootstrap methods"), bma.bootstrapMethods().stream().map(bm -> {
                        MethodHandleEntry mh = bm.bootstrapMethod();
                        MemberRefEntry mref = mh.reference();
                        MapNodeImpl bmNode = new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"bm"));
                        bmNode.with(ClassPrinterImpl.leafs(new ConstantDesc[]{"index", Integer.valueOf(bm.bsmIndex()), "kind", DirectMethodHandleDesc.Kind.valueOf(mh.kind(), mref instanceof InterfaceMethodRefEntry).name(), "owner", mref.owner().asInternalName(), "name", mref.nameAndType().name().stringValue()}));
                        bmNode.with(ClassPrinterImpl.list((ConstantDesc)((Object)"args"), (ConstantDesc)((Object)"arg"), bm.arguments().stream().map(LoadableConstantEntry::constantValue)));
                        return bmNode;
                    })));
                } else if (attr instanceof ConstantValueAttribute) {
                    ConstantValueAttribute cva = (ConstantValueAttribute)attr;
                    nodes.add(ClassPrinterImpl.leaf((ConstantDesc)((Object)"constant value"), cva.constant().constantValue()));
                } else if (attr instanceof NestHostAttribute) {
                    NestHostAttribute nha = (NestHostAttribute)attr;
                    nodes.add(ClassPrinterImpl.leaf((ConstantDesc)((Object)"nest host"), (ConstantDesc)((Object)nha.nestHost().name().stringValue())));
                } else if (attr instanceof NestMembersAttribute) {
                    NestMembersAttribute nma = (NestMembersAttribute)attr;
                    nodes.add(ClassPrinterImpl.list((ConstantDesc)((Object)"nest members"), (ConstantDesc)((Object)"member"), nma.nestMembers().stream().map(mp -> mp.name().stringValue())));
                } else if (attr instanceof PermittedSubclassesAttribute) {
                    PermittedSubclassesAttribute psa = (PermittedSubclassesAttribute)attr;
                    nodes.add(ClassPrinterImpl.list((ConstantDesc)((Object)"permitted subclasses"), (ConstantDesc)((Object)"subclass"), psa.permittedSubclasses().stream().map(e -> e.name().stringValue())));
                }
                if (verbosity != ClassPrinter.Verbosity.TRACE_ALL) continue;
                if (attr instanceof EnclosingMethodAttribute) {
                    EnclosingMethodAttribute ema = (EnclosingMethodAttribute)attr;
                    nodes.add(ClassPrinterImpl.map((ConstantDesc)((Object)"enclosing method"), new ConstantDesc[]{"class", ema.enclosingClass().name().stringValue(), "method name", ema.enclosingMethodName().map(Utf8Entry::stringValue).orElse(ConstantDescs.BSM_NULL_CONSTANT), "method type", ema.enclosingMethodType().map(Utf8Entry::stringValue).orElse(ConstantDescs.BSM_NULL_CONSTANT)}));
                    continue;
                }
                if (attr instanceof ExceptionsAttribute) {
                    ExceptionsAttribute exa = (ExceptionsAttribute)attr;
                    nodes.add(ClassPrinterImpl.list((ConstantDesc)((Object)"exceptions"), (ConstantDesc)((Object)"exc"), exa.exceptions().stream().map(e -> e.name().stringValue())));
                    continue;
                }
                if (attr instanceof InnerClassesAttribute) {
                    InnerClassesAttribute ica = (InnerClassesAttribute)attr;
                    nodes.add(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"inner classes"), ica.classes().stream().map(ic -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"cls")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"inner class"), (ConstantDesc)((Object)ic.innerClass().name().stringValue())), ClassPrinterImpl.leaf((ConstantDesc)((Object)"outer class"), ic.outerClass().map(cle -> cle.name().stringValue()).orElse(ConstantDescs.BSM_NULL_CONSTANT)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"inner name"), ic.innerName().map(Utf8Entry::stringValue).orElse(ConstantDescs.BSM_NULL_CONSTANT)), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), ic.flags().stream().map(Enum::name))))));
                    continue;
                }
                if (attr instanceof MethodParametersAttribute) {
                    MethodParametersAttribute mpa = (MethodParametersAttribute)attr;
                    MapNodeImpl n = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"method parameters"));
                    for (int i = 0; i < mpa.parameters().size(); ++i) {
                        MethodParameterInfo p = mpa.parameters().get(i);
                        n.with(new MapNodeImpl(Style.FLOW, Integer.valueOf(i + 1)).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"name"), p.name().map(Utf8Entry::stringValue).orElse(ConstantDescs.BSM_NULL_CONSTANT)), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), p.flags().stream().map(Enum::name))));
                    }
                    continue;
                }
                if (attr instanceof ModuleAttribute) {
                    ModuleAttribute ma = (ModuleAttribute)attr;
                    nodes.add(new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"module")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"name"), (ConstantDesc)((Object)ma.moduleName().name().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), ma.moduleFlags().stream().map(Enum::name)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"version"), ma.moduleVersion().map(Utf8Entry::stringValue).orElse(ConstantDescs.BSM_NULL_CONSTANT)), ClassPrinterImpl.list((ConstantDesc)((Object)"uses"), (ConstantDesc)((Object)"class"), ma.uses().stream().map(ce -> ce.name().stringValue())), new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"requires"), ma.requires().stream().map(req -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"req")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"name"), (ConstantDesc)((Object)req.requires().name().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), req.requiresFlags().stream().map(Enum::name)), ClassPrinterImpl.leaf((ConstantDesc)((Object)"version"), req.requiresVersion().map(Utf8Entry::stringValue).orElse(null))))), new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"exports"), ma.exports().stream().map(exp -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"exp")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"package"), (ConstantDesc)((Object)exp.exportedPackage().asSymbol().name())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), exp.exportsFlags().stream().map(Enum::name)), ClassPrinterImpl.list((ConstantDesc)((Object)"to"), (ConstantDesc)((Object)"module"), exp.exportsTo().stream().map(me -> me.name().stringValue()))))), new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"opens"), ma.opens().stream().map(opn -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"opn")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"package"), (ConstantDesc)((Object)opn.openedPackage().asSymbol().name())), ClassPrinterImpl.list((ConstantDesc)((Object)"flags"), (ConstantDesc)((Object)"flag"), opn.opensFlags().stream().map(Enum::name)), ClassPrinterImpl.list((ConstantDesc)((Object)"to"), (ConstantDesc)((Object)"module"), opn.opensTo().stream().map(me -> me.name().stringValue()))))), new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"provides"), ma.provides().stream().map(prov -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"prov")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"class"), (ConstantDesc)((Object)prov.provides().name().stringValue())), ClassPrinterImpl.list((ConstantDesc)((Object)"with"), (ConstantDesc)((Object)"cls"), prov.providesWith().stream().map(ce -> ce.name().stringValue())))))));
                    continue;
                }
                if (attr instanceof ModulePackagesAttribute) {
                    ModulePackagesAttribute mopa = (ModulePackagesAttribute)attr;
                    nodes.add(ClassPrinterImpl.list((ConstantDesc)((Object)"module packages"), (ConstantDesc)((Object)"subclass"), mopa.packages().stream().map(mp -> mp.asSymbol().name())));
                    continue;
                }
                if (attr instanceof ModuleMainClassAttribute) {
                    ModuleMainClassAttribute mmca = (ModuleMainClassAttribute)attr;
                    nodes.add(ClassPrinterImpl.leaf((ConstantDesc)((Object)"module main class"), (ConstantDesc)((Object)mmca.mainClass().name().stringValue())));
                    continue;
                }
                if (attr instanceof RecordAttribute) {
                    RecordAttribute ra = (RecordAttribute)attr;
                    nodes.add(new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"record components"), ra.components().stream().map(rc -> new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)"component")).with(ClassPrinterImpl.leafs(new ConstantDesc[]{"name", rc.name().stringValue(), "type", rc.descriptor().stringValue()})).with(ClassPrinterImpl.list((ConstantDesc)((Object)"attributes"), (ConstantDesc)((Object)"attribute"), rc.attributes().stream().map(Attribute::attributeName).map(Utf8Entry::stringValue))).with(ClassPrinterImpl.attributesToTree(rc.attributes(), verbosity)))));
                    continue;
                }
                if (attr instanceof AnnotationDefaultAttribute) {
                    AnnotationDefaultAttribute ada = (AnnotationDefaultAttribute)attr;
                    nodes.add(new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"annotation default")).with(ClassPrinterImpl.elementValueToTree(ada.defaultValue())));
                    continue;
                }
                if (attr instanceof RuntimeInvisibleAnnotationsAttribute) {
                    RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)attr;
                    nodes.add(ClassPrinterImpl.annotationsToTree("invisible annotations", aa.annotations()));
                    continue;
                }
                if (attr instanceof RuntimeVisibleAnnotationsAttribute) {
                    RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)attr;
                    nodes.add(ClassPrinterImpl.annotationsToTree("visible annotations", aa.annotations()));
                    continue;
                }
                if (attr instanceof RuntimeInvisibleParameterAnnotationsAttribute) {
                    RuntimeInvisibleParameterAnnotationsAttribute aa = (RuntimeInvisibleParameterAnnotationsAttribute)attr;
                    nodes.add(ClassPrinterImpl.parameterAnnotationsToTree("invisible parameter annotations", aa.parameterAnnotations()));
                    continue;
                }
                if (attr instanceof RuntimeVisibleParameterAnnotationsAttribute) {
                    RuntimeVisibleParameterAnnotationsAttribute aa = (RuntimeVisibleParameterAnnotationsAttribute)attr;
                    nodes.add(ClassPrinterImpl.parameterAnnotationsToTree("visible parameter annotations", aa.parameterAnnotations()));
                    continue;
                }
                if (attr instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
                    RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)attr;
                    nodes.add(ClassPrinterImpl.typeAnnotationsToTree(Style.BLOCK, "invisible type annotations", aa.annotations()));
                    continue;
                }
                if (attr instanceof RuntimeVisibleTypeAnnotationsAttribute) {
                    RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)attr;
                    nodes.add(ClassPrinterImpl.typeAnnotationsToTree(Style.BLOCK, "visible type annotations", aa.annotations()));
                    continue;
                }
                if (attr instanceof SignatureAttribute) {
                    SignatureAttribute sa = (SignatureAttribute)attr;
                    nodes.add(ClassPrinterImpl.leaf((ConstantDesc)((Object)"signature"), (ConstantDesc)((Object)sa.signature().stringValue())));
                    continue;
                }
                if (!(attr instanceof SourceFileAttribute)) continue;
                SourceFileAttribute sfa = (SourceFileAttribute)attr;
                nodes.add(ClassPrinterImpl.leaf((ConstantDesc)((Object)"source file"), (ConstantDesc)((Object)sfa.sourceFile().stringValue())));
            }
        }
        return (ClassPrinter.Node[])nodes.toArray(ClassPrinter.Node[]::new);
    }

    private static ClassPrinter.Node annotationsToTree(String name, List<Annotation> annos) {
        return new ListNodeImpl(Style.BLOCK, (ConstantDesc)((Object)name), annos.stream().map(a -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"anno")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"annotation class"), (ConstantDesc)((Object)a.className().stringValue()))).with(ClassPrinterImpl.elementValuePairsToTree(a.elements()))));
    }

    private static ClassPrinter.Node typeAnnotationsToTree(Style style, String name, List<TypeAnnotation> annos) {
        return new ListNodeImpl(style, (ConstantDesc)((Object)name), annos.stream().map(a -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"anno")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"annotation class"), (ConstantDesc)((Object)a.annotation().className().stringValue())), ClassPrinterImpl.leaf((ConstantDesc)((Object)"target info"), (ConstantDesc)((Object)a.targetInfo().targetType().name()))).with(ClassPrinterImpl.elementValuePairsToTree(a.annotation().elements()))));
    }

    private static MapNodeImpl parameterAnnotationsToTree(String name, List<List<Annotation>> paramAnnotations) {
        MapNodeImpl node = new MapNodeImpl(Style.BLOCK, (ConstantDesc)((Object)name));
        for (int i = 0; i < paramAnnotations.size(); ++i) {
            List<Annotation> annos = paramAnnotations.get(i);
            if (annos.isEmpty()) continue;
            node.with(new ListNodeImpl(Style.FLOW, (ConstantDesc)((Object)("parameter " + (i + 1))), annos.stream().map(a -> new MapNodeImpl(Style.FLOW, (ConstantDesc)((Object)"anno")).with(ClassPrinterImpl.leaf((ConstantDesc)((Object)"annotation class"), (ConstantDesc)((Object)a.className().stringValue()))).with(ClassPrinterImpl.elementValuePairsToTree(a.elements())))));
        }
        return node;
    }

    private static ClassPrinter.Node[] localInfoToTree(List<LocalVariableInfo> locals, int slot, int bci) {
        if (locals != null) {
            for (LocalVariableInfo l : locals) {
                if (l.slot() != slot || l.startPc() > bci || l.length() + l.startPc() < bci) continue;
                return ClassPrinterImpl.leafs(new ConstantDesc[]{"type", l.type().stringValue(), "variable name", l.name().stringValue()});
            }
        }
        return new ClassPrinter.Node[0];
    }

    private static void forEachOffset(TypeAnnotation ta, CodeAttribute lr, BiConsumer<Integer, TypeAnnotation> consumer) {
        TypeAnnotation.TargetInfo targetInfo = ta.targetInfo();
        if (targetInfo instanceof TypeAnnotation.OffsetTarget) {
            TypeAnnotation.OffsetTarget ot = (TypeAnnotation.OffsetTarget)targetInfo;
            consumer.accept(lr.labelToBci(ot.target()), ta);
        } else {
            targetInfo = ta.targetInfo();
            if (targetInfo instanceof TypeAnnotation.TypeArgumentTarget) {
                TypeAnnotation.TypeArgumentTarget tat = (TypeAnnotation.TypeArgumentTarget)targetInfo;
                consumer.accept(lr.labelToBci(tat.target()), ta);
            } else {
                targetInfo = ta.targetInfo();
                if (targetInfo instanceof TypeAnnotation.LocalVarTarget) {
                    TypeAnnotation.LocalVarTarget lvt = (TypeAnnotation.LocalVarTarget)targetInfo;
                    lvt.table().forEach(lvti -> consumer.accept(lr.labelToBci(lvti.startLabel()), ta));
                }
            }
        }
    }

    public record LeafNodeImpl(ConstantDesc name, ConstantDesc value) implements ClassPrinter.LeafNode
    {
        @Override
        public Stream<ClassPrinter.Node> walk() {
            return Stream.of(this);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class ListNodeImpl
    extends AbstractList<ClassPrinter.Node>
    implements ClassPrinter.ListNode {
        private final Style style;
        private final ConstantDesc name;
        protected final List<ClassPrinter.Node> nodes;

        public ListNodeImpl(Style style, ConstantDesc name, Stream<ClassPrinter.Node> nodes) {
            this.style = style;
            this.name = name;
            this.nodes = nodes.toList();
        }

        protected ListNodeImpl(Style style, ConstantDesc name, List<ClassPrinter.Node> nodes) {
            this.style = style;
            this.name = name;
            this.nodes = nodes;
        }

        @Override
        public ConstantDesc name() {
            return this.name;
        }

        @Override
        public Stream<ClassPrinter.Node> walk() {
            return Stream.concat(Stream.of(this), this.stream().flatMap(ClassPrinter.Node::walk));
        }

        public Style style() {
            return this.style;
        }

        @Override
        public ClassPrinter.Node get(int index) {
            return this.nodes.get(index);
        }

        @Override
        public int size() {
            return this.nodes.size();
        }
    }

    public static enum Style {
        BLOCK,
        FLOW;

    }

    public static final class MapNodeImpl
    implements ClassPrinter.MapNode {
        private final Style style;
        private final ConstantDesc name;
        private final Map<ConstantDesc, ClassPrinter.Node> map;

        public MapNodeImpl(Style style, ConstantDesc name) {
            this.style = style;
            this.name = name;
            this.map = new LinkedHashMap<ConstantDesc, ClassPrinter.Node>();
        }

        @Override
        public ConstantDesc name() {
            return this.name;
        }

        @Override
        public Stream<ClassPrinter.Node> walk() {
            return Stream.concat(Stream.of(this), this.values().stream().flatMap(ClassPrinter.Node::walk));
        }

        public Style style() {
            return this.style;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public ClassPrinter.Node get(Object key) {
            return this.map.get(key);
        }

        @Override
        public ClassPrinter.Node put(ConstantDesc key, ClassPrinter.Node value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassPrinter.Node remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends ConstantDesc, ? extends ClassPrinter.Node> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ConstantDesc> keySet() {
            return Collections.unmodifiableSet(this.map.keySet());
        }

        @Override
        public Collection<ClassPrinter.Node> values() {
            return Collections.unmodifiableCollection(this.map.values());
        }

        @Override
        public Set<Map.Entry<ConstantDesc, ClassPrinter.Node>> entrySet() {
            return Collections.unmodifiableSet(this.map.entrySet());
        }

        MapNodeImpl with(ClassPrinter.Node ... nodes) {
            for (ClassPrinter.Node n : nodes) {
                ClassPrinter.Node prev;
                if (n == null || (prev = this.map.putIfAbsent(n.name(), n)) == null) continue;
                if (prev instanceof PrivateListNodeImpl) {
                    PrivateListNodeImpl list = (PrivateListNodeImpl)prev;
                    list.nodes.add(n);
                    continue;
                }
                this.map.put(n.name(), new PrivateListNodeImpl(this.style, n.name(), prev, n));
            }
            return this;
        }

        private static final class PrivateListNodeImpl
        extends ListNodeImpl {
            PrivateListNodeImpl(Style style, ConstantDesc name, ClassPrinter.Node ... n) {
                super(style, name, new ArrayList<ClassPrinter.Node>(List.of(n)));
            }
        }
    }

    private record ExceptionHandler(int start, int end, int handler, String catchType) {
    }
}

