/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.CodeModel;
import io.smallrye.classfile.CodeTransform;
import io.smallrye.classfile.MethodBuilder;
import io.smallrye.classfile.MethodElement;
import io.smallrye.classfile.constantpool.ConstantPoolBuilder;
import io.smallrye.classfile.impl.BufferedCodeBuilder;
import io.smallrye.classfile.impl.TerminalMethodBuilder;
import java.util.Objects;
import java.util.function.Consumer;

public final class ChainedMethodBuilder
implements MethodBuilder {
    final TerminalMethodBuilder terminal;
    final Consumer<MethodElement> consumer;

    public ChainedMethodBuilder(MethodBuilder downstream, Consumer<MethodElement> consumer) {
        TerminalMethodBuilder terminalMethodBuilder;
        this.consumer = consumer;
        if (downstream instanceof ChainedMethodBuilder) {
            ChainedMethodBuilder cmb = (ChainedMethodBuilder)downstream;
            terminalMethodBuilder = cmb.terminal;
        } else {
            terminalMethodBuilder = (TerminalMethodBuilder)downstream;
        }
        this.terminal = terminalMethodBuilder;
    }

    @Override
    public MethodBuilder with(MethodElement element) {
        this.consumer.accept(Objects.requireNonNull(element));
        return this;
    }

    @Override
    public MethodBuilder withCode(Consumer<? super CodeBuilder> handler) {
        this.consumer.accept(this.terminal.bufferedCodeBuilder(null).run(handler).toModel());
        return this;
    }

    @Override
    public MethodBuilder transformCode(CodeModel code, CodeTransform transform) {
        BufferedCodeBuilder builder = this.terminal.bufferedCodeBuilder(code);
        builder.transform(code, transform);
        this.consumer.accept(builder.toModel());
        return this;
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.terminal.constantPool();
    }
}

